/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.PublicPermissionCheck;
import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.MetaDataImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalPermission;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.SortNatural;

@Entity
@Table(name="ENTITIES")
@DiscriminatorColumn(columnDefinition="char(1)", name="TYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="F")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="PrimaryDataFile")
public class PrimaryDataFileImplementation
extends PrimaryDataFile {
    private SortedSet<PrimaryDataEntityVersionImplementation> versionList;

    protected PrimaryDataFileImplementation() {
    }

    public PrimaryDataFileImplementation(PrimaryDataDirectory path, String name) throws PrimaryDataFileException, PrimaryDataEntityVersionException, PrimaryDataDirectoryException, MetaDataException {
        super(path, name);
    }

    private void deleteVersion(PrimaryDataEntityVersion version) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(version);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("unable to delete File", e);
        }
        this.getImplementationProvider().getLogger().info("rollback FileSytem");
    }

    @Override
    protected boolean existData() {
        return Files.exists(this.getPathToLocalFile(this.getCurrentVersion()), LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    @Id
    @Column(columnDefinition="char(40)")
    public String getID() {
        String string;
        PublicPermissionCheck.ajc$cflowCounter$5.inc();
        try {
            string = super.getID();
        }
        finally {
            PublicPermissionCheck.ajc$cflowCounter$5.dec();
        }
        return string;
    }

    @Override
    @OneToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public PrimaryDataDirectoryImplementation getParentDirectory() throws PrimaryDataDirectoryException {
        return (PrimaryDataDirectoryImplementation)super.getParentDirectory();
    }

    protected Path getPathToLocalFile(PrimaryDataEntityVersion version) {
        Path path = Paths.get(((FileSystemImplementationProvider)this.getImplementationProvider()).getDataPath().toString(), String.valueOf(version.getCreationDate().get(1)), String.valueOf(version.getCreationDate().get(2)), String.valueOf(version.getCreationDate().get(5)), String.valueOf(version.getCreationDate().get(11)), String.valueOf(version.getCreationDate().get(12)), String.valueOf(this.getID()) + "-" + version.getRevision() + ".dat");
        return path;
    }

    @Override
    @Transient
    protected Map<Principal, List<EdalPermission>> getPermissionsImpl() throws PrimaryDataEntityException {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EdalPermissionImplementation.class);
        Root rootPermission = criteria.from(EdalPermissionImplementation.class);
        criteria.where((Expression)builder.and((Expression)builder.equal((Expression)rootPermission.get("internId"), (Object)this.getID()), (Expression)builder.equal((Expression)rootPermission.get("internVersion"), (Object)this.getCurrentVersion().getRevision())));
        List privatePerms = session.createQuery(criteria).getResultList();
        HashMap<Principal, List<EdalPermission>> publicMap = new HashMap<Principal, List<EdalPermission>>();
        try {
            for (EdalPermissionImplementation p : privatePerms) {
                if (publicMap.containsKey(p.getPrincipal().toPrincipal())) continue;
                CriteriaQuery tmpQuery = builder.createQuery(EdalPermissionImplementation.class);
                Root rootTempPermission = criteria.from(EdalPermissionImplementation.class);
                tmpQuery.where((Expression)builder.and((Expression)builder.and((Expression)builder.equal((Expression)rootTempPermission.get("internId"), (Object)this.getID()), (Expression)builder.equal((Expression)rootTempPermission.get("internVersion"), (Object)this.getCurrentVersion().getRevision())), (Expression)builder.equal((Expression)rootTempPermission.get("principal"), (Object)p.getPrincipal())));
                List userPerms = session.createQuery(tmpQuery).getResultList();
                ArrayList<EdalPermission> publicPerms = new ArrayList<EdalPermission>(privatePerms.size());
                for (EdalPermissionImplementation permission : userPerms) {
                    publicPerms.add(permission.toEdalPermission());
                }
                publicMap.put(p.getPrincipal().toPrincipal(), publicPerms);
            }
        }
        catch (Exception e) {
            session.close();
            throw new PrimaryDataEntityException("Unable to load permissions !", e);
        }
        session.close();
        return publicMap;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="primaryEntityId")
    @SortNatural
    protected SortedSet<PrimaryDataEntityVersionImplementation> getVersionList() {
        return this.versionList;
    }

    @Override
    @Transient
    protected SortedSet<PrimaryDataEntityVersion> getVersionsImpl() {
        if (this.getVersionList() == null) {
            return Collections.synchronizedSortedSet(new TreeSet());
        }
        return Collections.synchronizedSortedSet(new TreeSet<PrimaryDataEntityVersionImplementation>((Collection<PrimaryDataEntityVersionImplementation>)this.getVersionList()));
    }

    @Override
    protected void moveImpl(PrimaryDataDirectory destinationDirectory) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        this.setParentDirectory(destinationDirectory);
        session.update((Object)this);
        transaction.commit();
        session.close();
    }

    @Override
    protected void readImpl(OutputStream outputStream) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(this.getCurrentVersion());
        try {
            int length;
            byte[] buffer = new byte[0xA00000];
            FileInputStream inputStream = new FileInputStream(path.toFile());
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                outputStream.flush();
            }
            inputStream.close();
            this.getImplementationProvider().getLogger().info("File read: " + path);
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                throw new PrimaryDataFileException("Can not read File '" + this + "': OutputStream no longer available", e);
            }
            throw new PrimaryDataFileException("Can not read '" + this + "': " + e.getMessage(), e);
        }
    }

    protected void setVersionList(SortedSet<PrimaryDataEntityVersionImplementation> versionList) {
        this.versionList = Collections.synchronizedSortedSet(versionList);
        this.setCurrentVersion(this.versionList.last());
    }

    @Override
    protected void storeImpl(InputStream inputStream, PrimaryDataEntityVersion currentVersion) throws PrimaryDataFileException {
        Path path = this.getPathToLocalFile(currentVersion);
        try {
            int length;
            if (Files.notExists(path, LinkOption.NOFOLLOW_LINKS)) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            byte[] buffer = new byte[0xA00000];
            FileOutputStream outputStream = new FileOutputStream(path.toFile());
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            inputStream.close();
            outputStream.close();
            this.getImplementationProvider().getLogger().info("File saved: " + path);
        }
        catch (IOException e) {
            throw new PrimaryDataFileException("Can not store File : " + e.getMessage(), e);
        }
    }

    @Override
    protected void storeVersion(PrimaryDataEntityVersion publicVersion) throws PrimaryDataEntityVersionException {
        Session session;
        PrimaryDataEntityVersionImplementation privateVersion;
        block11: {
            MetaDataImplementation metadata = (MetaDataImplementation)publicVersion.getMetaData();
            privateVersion = new PrimaryDataEntityVersionImplementation();
            privateVersion.setCreationDate(publicVersion.getCreationDate());
            privateVersion.setPrimaryEntityId(this.getID());
            privateVersion.setMetaData(metadata);
            privateVersion.setRevision(publicVersion.getRevision());
            privateVersion.setDeleted(publicVersion.isDeleted());
            ArrayList<PublicReferenceImplementation> list = new ArrayList<PublicReferenceImplementation>();
            for (PublicReference publicReference : publicVersion.getPublicReferences()) {
                PublicReferenceImplementation privateReference = new PublicReferenceImplementation(publicReference);
                privateReference.setVersion(privateVersion);
                list.add(privateReference);
            }
            privateVersion.setInternReferences(list);
            session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            Transaction transaction = session.beginTransaction();
            try {
                session.saveOrUpdate((Object)this);
                session.saveOrUpdate((Object)privateVersion);
                transaction.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (transaction == null) break block11;
                transaction.rollback();
                this.getImplementationProvider().getLogger().info("Unable to store PrimaryDataEntityVersion : " + e.getMessage() + " --> rollback Transaction");
                try {
                    this.deleteVersion(publicVersion);
                }
                catch (PrimaryDataFileException e1) {
                    e1.printStackTrace();
                }
                session.close();
                throw new PrimaryDataEntityVersionException("Can not store Version into Database - rollback successful");
            }
        }
        if (this.versionList == null) {
            this.versionList = Collections.synchronizedSortedSet(new TreeSet());
            this.versionList.add(privateVersion);
            Collections.synchronizedSortedSet(this.versionList);
        } else {
            this.versionList.add(privateVersion);
            Collections.synchronizedSortedSet(this.versionList);
        }
        this.setCurrentVersion(privateVersion);
        try {
            this.setDefaultPermissions();
        }
        catch (PrimaryDataEntityException e) {
            throw new PrimaryDataEntityVersionException("Unable to store default permissions : " + e.getMessage(), e);
        }
        Iterator<Principal> iterator = DataManager.getSubject().getPrincipals().iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            Transaction transaction2 = session.beginTransaction();
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(PrincipalImplementation.class);
            Root root = criteria.from(PrincipalImplementation.class);
            criteria.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("name"), (Object)principal.getName()), (Expression)builder.equal((Expression)root.get("type"), (Object)principal.getClass().getSimpleName())));
            PrincipalImplementation existingPrincipal = (PrincipalImplementation)session.createQuery(criteria).uniqueResult();
            if (existingPrincipal == null) {
                throw new PrimaryDataEntityVersionException("Unable to load existing Principal");
            }
            privateVersion.setOwner(existingPrincipal);
            session.saveOrUpdate((Object)privateVersion);
            transaction2.commit();
            session.close();
        }
        this.setCurrentVersion(privateVersion);
    }
}

