/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReferenceException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.ReviewStatusImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.Referenceable;
import java.io.Serializable;
import java.security.Principal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.type.BooleanType;

@Entity
@TypeDefs(value={@TypeDef(name="BooleanType", typeClass=BooleanType.class)})
@Table(name="PublicReferences")
public final class PublicReferenceImplementation
extends PublicReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private PrimaryDataEntityVersionImplementation version;
    private PersistentIdentifier identifierType;
    private boolean isPublic;
    private String assignedID;
    private String landingPage;
    private String internalID;
    private PrincipalImplementation privateRequestedPrincipal;
    private Set<ReviewStatusImplementation> reviewStatusSet = new HashSet<ReviewStatusImplementation>();

    protected PublicReferenceImplementation() {
    }

    protected PublicReferenceImplementation(PublicReference pub) {
        PrincipalImplementation principal;
        this.identifierType = pub.getIdentifierType();
        this.isPublic = pub.isPublic();
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.where(new Predicate[]{builder.and(new Predicate[]{builder.equal((Expression)principalRoot.get("name"), (Object)pub.getRequestedPrincipal().getName())}), builder.equal((Expression)principalRoot.get("type"), (Object)pub.getRequestedPrincipal().getClass().getSimpleName())});
        this.privateRequestedPrincipal = principal = (PrincipalImplementation)session.createQuery(principalCriteria).setCacheable(true).setCacheRegion("query.principal").uniqueResult();
        this.internalID = pub.getInternalID();
        session.close();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getAcceptedDate() {
        return super.getAcceptedDate();
    }

    @Override
    public String getAssignedID() throws PublicReferenceException {
        return this.assignedID;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreationDate() {
        return super.getCreationDate();
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public PersistentIdentifier getIdentifierType() {
        return this.identifierType;
    }

    @ManyToOne
    protected PrincipalImplementation getPrivateRequestedPrincipal() {
        return this.privateRequestedPrincipal;
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public PublicationStatus getPublicationStatus() {
        return super.getPublicationStatus();
    }

    @Override
    @Transient
    public Referenceable getReferencable() throws EdalException {
        try {
            return this.identifierType.getImplClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new EdalException("unable to load the class for the identifierType '" + (Object)((Object)this.identifierType) + "' : " + e.getMessage());
        }
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getReleaseDate() {
        return super.getReleaseDate();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getRejectedDate() {
        return super.getRejectedDate();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getRequestedDate() {
        return super.getRequestedDate();
    }

    @Override
    @Transient
    public Principal getRequestedPrincipal() {
        try {
            return this.getPrivateRequestedPrincipal().toPrincipal();
        }
        catch (EdalException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @ManyToOne(cascade={CascadeType.ALL})
    public PrimaryDataEntityVersionImplementation getVersion() {
        return this.version;
    }

    @Override
    @Type(type="BooleanType")
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    protected void setAcceptedDate(Calendar acceptedDate) {
        super.setAcceptedDate(acceptedDate);
    }

    @Override
    protected void setAssignedID(String assignedID) {
        this.assignedID = assignedID;
    }

    @Override
    protected void setCreationDate(Calendar creationDate) {
        super.setCreationDate(creationDate);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIdentifierType(PersistentIdentifier identifierType) {
        this.identifierType = identifierType;
    }

    protected void setPrivateRequestedPrincipal(PrincipalImplementation requestedPrincipal) {
        this.privateRequestedPrincipal = requestedPrincipal;
    }

    protected void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    protected void setPublicationStatus(PublicationStatus publicationStatus) {
        super.setPublicationStatus(publicationStatus);
    }

    @Override
    protected void setRejectedDate(Calendar rejectedDate) {
        super.setRejectedDate(rejectedDate);
    }

    @Override
    protected void setRequestedDate(Calendar requestedDate) {
        super.setRequestedDate(requestedDate);
    }

    @Override
    protected void setReleaseDate(Calendar releaseDate) {
        super.setReleaseDate(releaseDate);
    }

    @Override
    public void changeReleaseDate(Calendar releaseDate) {
        super.changeReleaseDate(releaseDate);
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)this);
        transaction.commit();
        session.close();
    }

    protected void setVersion(PrimaryDataEntityVersionImplementation version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "PublicReferenceImplementation [version=" + this.version + ", identifierType=" + (Object)((Object)this.identifierType) + ", isPublic=" + this.isPublic + "]";
    }

    @OneToMany(fetch=FetchType.EAGER, targetEntity=ReviewStatusImplementation.class, mappedBy="publicReference")
    public Set<ReviewStatusImplementation> getReviewStatusSet() {
        return this.reviewStatusSet;
    }

    public void setReviewStatusSet(Set<ReviewStatusImplementation> reviewStatusSet) {
        this.reviewStatusSet = reviewStatusSet;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @Override
    public String getInternalID() {
        return this.internalID;
    }

    @Override
    protected void setInternalID(String internalID) {
        this.internalID = internalID;
    }
}

