/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalHttpHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalThreadPoolExcecutor;
import de.ipk_gatersleben.bit.bi.edal.primary_data.ServiceProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReference;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.CalculateDirectorySizeThread;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.EdalPermissionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataDirectoryImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataEntityVersionImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrimaryDataFileImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PrincipalImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.PublicReferenceImplementation;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DataSize;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PublicationStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;

public class ServiceProviderImplementation
implements ServiceProvider {
    public static boolean cleaned = false;
    private static final int DaysAfterCleanBrokenEntities = -14;
    public static final Path PATH_FOR_DIRECTORY_SIZE_MAP = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "directory_size_map.dat");
    public static final Path PATH_FOR_DIRECTORY_FILE_MAP = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "directory_file_map.dat");
    public static final Path PATH_FOR_TOTAL_FILE_NUMBER = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "number_of_files.dat");
    public static final Path PATH_FOR_TOTAL_VOLUME = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "total_volume.dat");
    public static final Path PATH_FOR_REFERENCE_CONTENT = Paths.get(DataManager.getImplProv().getConfiguration().getMountPath().toString(), "reference_content.dat");
    public static Long totalNumberOfFiles;
    public static Long numberOfReferenceFiles;
    public static Long numberOfReferenceDirectories;
    public static Long volumeOfReference;
    private static final int MIN_NUMBER_OF_THREADS_IN_POOL = 2;
    private static final int MAX_NUMBER_OF_THREADS_IN_EXECUTOR_QUEUE = 30;
    private static final int EXCUTOR_THREAD_KEEP_ALIVE_SECONDS = 60;
    private static final String EXECUTOR_NAME = "ServiceProviderExecutor";
    private static ThreadPoolExecutor executor;

    static {
        executor = Runtime.getRuntime().availableProcessors() / 2 > 2 ? new EdalThreadPoolExcecutor(Runtime.getRuntime().availableProcessors() / 2, Runtime.getRuntime().availableProcessors() / 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), EXECUTOR_NAME) : new EdalThreadPoolExcecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), EXECUTOR_NAME);
    }

    @Override
    public Long getUsedStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            final AtomicLong size = new AtomicLong();
            Files.walkFileTree(DataManager.getImplProv().getConfiguration().getDataPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request used space", e);
        }
    }

    @Override
    public Long getAvailableStorageSpace() throws EdalException {
        if (DataManager.getImplProv().getConfiguration().getDataPath() == null || Files.notExists(DataManager.getImplProv().getConfiguration().getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            throw new EdalException("No mount path defined, please run getRootDirectory first");
        }
        try {
            return Files.getFileStore(DataManager.getImplProv().getConfiguration().getDataPath()).getUsableSpace();
        }
        catch (IOException e) {
            throw new EdalException("Unable to request available space", e);
        }
    }

    @Override
    public synchronized void cleanUpForRejectedEntities() {
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("CLEAN UP initiated");
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery referenceCriteria = builder.createQuery(PublicReferenceImplementation.class);
        Root referenceRoot = referenceCriteria.from(PublicReferenceImplementation.class);
        referenceCriteria.where((Expression)builder.equal((Expression)referenceRoot.get("publicationStatus"), (Object)PublicationStatus.REJECTED));
        List references = session.createQuery(referenceCriteria).list();
        session.getTransaction().commit();
        session.close();
        boolean foundReferenceToDelete = false;
        if (references != null) {
            foundReferenceToDelete = true;
        }
        for (PublicReferenceImplementation reference : references) {
            PrimaryDataEntity entity = reference.getVersion().getEntity();
            if (entity.getVersions().size() == 3 && !entity.isDirectory()) {
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)entity);
                continue;
            }
            if (entity.getVersions().size() != 3 || !entity.isDirectory()) continue;
            this.deleteRecursiveDirectory((PrimaryDataDirectoryImplementation)entity);
        }
        if (foundReferenceToDelete) {
            this.setCleaned(true);
        }
        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("CLEAN UP finished");
    }

    private void deleteRecursiveDirectory(PrimaryDataDirectoryImplementation directory) {
        try {
            Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session.beginTransaction();
            this.deleteFilesRecursively(session, directory);
            session.getTransaction().commit();
            session.close();
            Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session2.beginTransaction();
            this.deleteDirectoriesRecursively(session2, directory);
            session2.getTransaction().commit();
            session2.close();
        }
        catch (PrimaryDataDirectoryException e) {
            e.printStackTrace();
        }
        this.deleteDirectoryAndPermissions(directory);
    }

    public void deleteDirectoriesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (!primaryDataEntity.isDirectory()) continue;
                if (((PrimaryDataDirectory)primaryDataEntity).listPrimaryDataEntities().size() == 0) {
                    this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
                    continue;
                }
                this.deleteDirectoriesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                this.deleteDirectoryAndPermissions((PrimaryDataDirectoryImplementation)primaryDataEntity);
            }
        }
    }

    public void deleteFilesRecursively(Session session, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException {
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                if (primaryDataEntity.isDirectory()) {
                    this.deleteFilesRecursively(session, (PrimaryDataDirectory)primaryDataEntity);
                    continue;
                }
                this.deleteFileAndPermissions((PrimaryDataFileImplementation)primaryDataEntity);
            }
        }
    }

    private void deleteFileAndPermissions(PrimaryDataFileImplementation file) {
        DataManager.getImplProv().getLogger().info("Deleting concrete date file '" + file.getName() + "'");
        ArrayList<Integer> versionIds = new ArrayList<Integer>();
        for (PrimaryDataEntityVersion version : file.getVersions()) {
            versionIds.add(((PrimaryDataEntityVersionImplementation)version).getId());
            Path path = file.getPathToLocalFile(version);
            DeleteThread tread = new DeleteThread(path);
            if (executor.isShutdown()) {
                executor = Runtime.getRuntime().availableProcessors() / 2 > 2 ? new EdalThreadPoolExcecutor(Runtime.getRuntime().availableProcessors() / 2, Runtime.getRuntime().availableProcessors() / 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), EXECUTOR_NAME) : new EdalThreadPoolExcecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), EXECUTOR_NAME);
            }
            executor.execute(tread);
        }
        DataManager.getImplProv().getLogger().info("Deleting PrimaryDataFile '" + file.getName() + "'");
        Session session1 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session1.beginTransaction();
        CriteriaBuilder builder = session1.getCriteriaBuilder();
        CriteriaQuery versionCriteria = builder.createQuery(PrimaryDataEntityVersionImplementation.class);
        Root versionRoot = versionCriteria.from(PrimaryDataEntityVersionImplementation.class);
        versionCriteria.where((Expression)builder.equal((Expression)versionRoot.get("primaryEntityId"), (Object)file.getID()));
        List allExistingVersionsInDB = session1.createQuery(versionCriteria).list();
        session1.getTransaction().commit();
        session1.close();
        for (PrimaryDataEntityVersionImplementation version : allExistingVersionsInDB) {
            if (versionIds.contains(version.getId())) continue;
            System.out.println("Needless version found " + version.getId());
            Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session2.beginTransaction();
            session2.delete((Object)version);
            session2.getTransaction().commit();
            session2.close();
        }
        try {
            Session session3 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session3.beginTransaction();
            CriteriaQuery permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
            Root permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
            permissionCriteria.where((Expression)builder.equal((Expression)permissionRoot.get("internId"), (Object)file.getID()));
            List permissions = session3.createQuery(permissionCriteria).list();
            for (EdalPermissionImplementation permission : permissions) {
                session3.delete((Object)permission);
            }
            session3.getTransaction().commit();
            session3.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Session session4 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session4.beginTransaction();
            session4.delete((Object)file);
            session4.getTransaction().commit();
            session4.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectoryAndPermissions(PrimaryDataDirectoryImplementation directory) {
        DataManager.getImplProv().getLogger().info("Deleting PrimaryDataDirectory " + directory.getName());
        ArrayList<Integer> versionIds = new ArrayList<Integer>();
        for (PrimaryDataEntityVersion version : directory.getVersions()) {
            versionIds.add(((PrimaryDataEntityVersionImplementation)version).getId());
        }
        Session session1 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session1.beginTransaction();
        CriteriaBuilder builder = session1.getCriteriaBuilder();
        CriteriaQuery versionCriteria = builder.createQuery(PrimaryDataEntityVersionImplementation.class);
        Root principalRoot = versionCriteria.from(PrimaryDataEntityVersionImplementation.class);
        versionCriteria.where((Expression)builder.equal((Expression)principalRoot.get("primaryEntityId"), (Object)directory.getID()));
        List allExistingVersionsInDB = session1.createQuery(versionCriteria).list();
        session1.getTransaction().commit();
        session1.close();
        for (PrimaryDataEntityVersionImplementation version : allExistingVersionsInDB) {
            if (versionIds.contains(version.getId())) continue;
            System.out.println("Needless version found " + version.getId());
            Session session2 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session2.beginTransaction();
            session2.delete((Object)version);
            session2.getTransaction().commit();
            session2.close();
        }
        try {
            Session session3 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session3.beginTransaction();
            CriteriaQuery permissionCriteria = builder.createQuery(EdalPermissionImplementation.class);
            Root permissionRoot = permissionCriteria.from(EdalPermissionImplementation.class);
            permissionCriteria.where((Expression)builder.equal((Expression)permissionRoot.get("internId"), (Object)directory.getID()));
            List permissions = session3.createQuery(permissionCriteria).list();
            for (EdalPermissionImplementation permission : permissions) {
                session3.delete((Object)permission);
            }
            session3.getTransaction().commit();
            session3.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Session session4 = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
            session4.beginTransaction();
            session4.delete((Object)directory);
            session4.getTransaction().commit();
            session4.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Long listDirectory(PublicReference reference, PrimaryDataDirectory currentDirectory) throws PrimaryDataDirectoryException, MetaDataException {
        if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(reference.getInternalID()) + "/" + currentDirectory.getID())) {
            return CalculateDirectorySizeThread.directorySizes.get(String.valueOf(reference.getInternalID()) + "/" + currentDirectory.getID());
        }
        List<PrimaryDataEntity> list = currentDirectory.listPrimaryDataEntities();
        Long volumeOfCurrentDirectory = 0L;
        Long numberOfFilesInCurrentDirectory = 0L;
        Long numberOfDirectoriesInCurrentDirectory = 0L;
        if (list != null) {
            for (PrimaryDataEntity primaryDataEntity : list) {
                DataSize mySize = (DataSize)primaryDataEntity.getMetaData().getElementValue(EnumDublinCoreElements.SIZE);
                volumeOfCurrentDirectory = volumeOfCurrentDirectory + mySize.getFileSize();
                volumeOfReference = volumeOfReference + mySize.getFileSize();
                if (primaryDataEntity.isDirectory()) {
                    volumeOfCurrentDirectory = volumeOfCurrentDirectory + this.listDirectory(reference, (PrimaryDataDirectory)primaryDataEntity);
                    numberOfReferenceDirectories = numberOfReferenceDirectories + 1L;
                    numberOfDirectoriesInCurrentDirectory = numberOfDirectoriesInCurrentDirectory + 1L;
                    continue;
                }
                if (!reference.getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) continue;
                numberOfReferenceFiles = numberOfReferenceFiles + 1L;
                totalNumberOfFiles = totalNumberOfFiles + 1L;
                numberOfFilesInCurrentDirectory = numberOfFilesInCurrentDirectory + 1L;
            }
            CalculateDirectorySizeThread.directorySizes.put(String.valueOf(reference.getInternalID()) + "/" + currentDirectory.getID(), volumeOfCurrentDirectory);
            CalculateDirectorySizeThread.directoryFiles.put(String.valueOf(reference.getInternalID()) + "/" + currentDirectory.getID(), String.valueOf(numberOfDirectoriesInCurrentDirectory.toString()) + "," + numberOfFilesInCurrentDirectory.toString());
        }
        return volumeOfCurrentDirectory;
    }

    private void storeValuesToDisk() {
        ObjectOutputStream oos;
        File file = PATH_FOR_DIRECTORY_SIZE_MAP.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.directorySizes);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_DIRECTORY_FILE_MAP.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.directoryFiles);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_TOTAL_FILE_NUMBER.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(totalNumberOfFiles);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_TOTAL_VOLUME.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.totalVolumeDataStock);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
        file = PATH_FOR_REFERENCE_CONTENT.toFile();
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(CalculateDirectorySizeThread.referenceContent);
            oos.close();
        }
        catch (Exception e) {
            ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().error((Object)e);
        }
    }

    @Override
    public synchronized void calculateDirectorySizes() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery referenceCriteria = builder.createQuery(PublicReferenceImplementation.class);
        Root permissionRoot = referenceCriteria.from(PublicReferenceImplementation.class);
        referenceCriteria.select((Selection)permissionRoot);
        List references = session.createQuery(referenceCriteria).list();
        session.close();
        boolean updated = false;
        for (PublicReferenceImplementation reference : references) {
            numberOfReferenceFiles = 0L;
            numberOfReferenceDirectories = 0L;
            volumeOfReference = 0L;
            if (CalculateDirectorySizeThread.directorySizes.containsKey(String.valueOf(reference.getInternalID()) + "/" + reference.getVersion().getEntity().getID())) continue;
            try {
                Long size = this.listDirectory(reference, (PrimaryDataDirectory)reference.getVersion().getEntity());
                if (reference.getPublicationStatus().equals((Object)PublicationStatus.ACCEPTED)) {
                    CalculateDirectorySizeThread.totalVolumeDataStock += size.longValue();
                }
                CalculateDirectorySizeThread.referenceContent.put(reference.getInternalID(), numberOfReferenceDirectories + "," + numberOfReferenceFiles + "," + volumeOfReference);
                this.storeValuesToDisk();
                updated = true;
            }
            catch (PrimaryDataDirectoryException | MetaDataException e) {
                e.printStackTrace();
            }
        }
        if (updated) {
            DataManager.getImplProv().getLogger().info("Cleaning Webpage_Cache...");
            EdalHttpHandler.contentPageCache.clean();
            DataManager.getImplProv().getLogger().info("Webpage_Cache cleaned");
        }
    }

    @Override
    public int getNumberOfUsers() {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.select((Selection)principalRoot);
        List numberOfUsers = session.createQuery(principalCriteria).list();
        session.getTransaction().commit();
        session.close();
        return numberOfUsers.size();
    }

    @Override
    public void cleanUpForBrokenEntities(PrimaryDataDirectory root) {
        Session session = ((FileSystemImplementationProvider)DataManager.getImplProv()).getSession();
        session.beginTransaction();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery principalCriteria = builder.createQuery(PrincipalImplementation.class);
        Root principalRoot = principalCriteria.from(PrincipalImplementation.class);
        principalCriteria.select((Selection)principalRoot);
        List users = session.createQuery(principalCriteria).list();
        session.getTransaction().commit();
        session.close();
        for (PrincipalImplementation principal : users) {
            String user = principal.getName();
            try {
                for (PrimaryDataEntity entity : root.listPrimaryDataEntities()) {
                    if (!entity.getName().equals(user)) continue;
                    for (PrimaryDataEntity ent : ((PrimaryDataDirectory)entity).listPrimaryDataEntities()) {
                        if (!ent.isDirectory() || ent.getPublicReferences().size() != 0) continue;
                        Calendar today = Calendar.getInstance();
                        today.add(6, -14);
                        Calendar c = ent.getCurrentVersion().getCreationDate();
                        if (!c.before(today)) continue;
                        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("CLEAN UP for broken Entities initiated");
                        this.deleteRecursiveDirectory((PrimaryDataDirectoryImplementation)ent);
                        ((FileSystemImplementationProvider)DataManager.getImplProv()).getLogger().info("CLEAN UP for broken Entities finished");
                        this.setCleaned(true);
                    }
                }
            }
            catch (PrimaryDataDirectoryException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCleaned() {
        return cleaned;
    }

    @Override
    public void setCleaned(boolean flag) {
        cleaned = flag;
    }

    class DeleteThread
    extends Thread {
        private Path path;

        public DeleteThread(Path path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

