/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.login;

import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ElixirSwingBrowserDialog
extends JDialog {
    private static final long serialVersionUID = -3918755777891924805L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnHelp = new JButton("Help");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();

    static {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Class.forName("javafx.application.Platform");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please use an Oracle_JRE to run this module", "No Oracle_JRE found", 0);
            System.exit(-1);
        }
    }

    public ElixirSwingBrowserDialog(Frame parent, String url) {
        super(parent, true);
        this.initComponents(parent);
        this.loadURL(url);
    }

    private void initComponents(Frame parent) {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(ElixirSwingBrowserDialog.this.btnHelp)) {
                    EdalHelpers.openURL("http://edal-pgp.ipk-gatersleben.de/document/elixir.html");
                } else {
                    ElixirSwingBrowserDialog.this.loadURL(ElixirSwingBrowserDialog.this.txtURL.getText());
                }
            }
        };
        this.btnHelp.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(200, 10));
        this.progressBar.setStringPainted(true);
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.btnHelp, "West");
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(800, 850));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                ElixirSwingBrowserDialog.this.engine = view.getEngine();
                ElixirSwingBrowserDialog.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialog.this.setTitle(newValue);
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialog.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialog.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialog.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialog.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialog.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialog.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialog.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (ElixirSwingBrowserDialog.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(ElixirSwingBrowserDialog.this.panel, value != null ? String.valueOf(ElixirSwingBrowserDialog.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(ElixirSwingBrowserDialog.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                ElixirSwingBrowserDialog.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = ElixirSwingBrowserDialog.toURL(url);
                if (tmp == null) {
                    tmp = ElixirSwingBrowserDialog.toURL("http://" + url);
                }
                URI uri = URI.create(tmp);
                LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                headers.put("Set-Cookie", Arrays.asList("name=value"));
                try {
                    CookieHandler.getDefault().put(uri, headers);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ElixirSwingBrowserDialog.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.setImplicitExit((boolean)false);
        ElixirSwingBrowserDialog browser = new ElixirSwingBrowserDialog(null, "http://www.google.de");
        browser.setVisible(true);
        ElixirSwingBrowserDialog browser2 = new ElixirSwingBrowserDialog(null, "http://www.google.de");
        browser2.setVisible(true);
        Platform.setImplicitExit((boolean)true);
    }
}

