/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.login;

import de.ipk_gatersleben.bit.bi.edal.primary_data.login.CookieUtil;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.CustomCookieStore;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ElixirSwingBrowserDialogWithCookies
extends JDialog {
    private static final long serialVersionUID = -3918755777891924805L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnHelp = new JButton("Help");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final Path CookieStore = Paths.get(System.getProperty("user.home"), ".eDAL", "cookie.txt");

    static {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Class.forName("javafx.application.Platform");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please use an Oracle_JRE to run this module", "No Oracle_JRE found", 0);
            System.exit(-1);
        }
    }

    public ElixirSwingBrowserDialogWithCookies(Frame parent, String url) {
        super(parent, true);
        this.initComponents(parent);
        this.loadURL(url);
    }

    private void initComponents(Frame parent) {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(ElixirSwingBrowserDialogWithCookies.this.btnHelp)) {
                    EdalHelpers.openURL("http://edal-pgp.ipk-gatersleben.de/document/elixir.html");
                } else {
                    ElixirSwingBrowserDialogWithCookies.this.loadURL(ElixirSwingBrowserDialogWithCookies.this.txtURL.getText());
                }
            }
        };
        this.btnHelp.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(200, 10));
        this.progressBar.setStringPainted(true);
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.btnHelp, "West");
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(800, 850));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                CookieManager manager = new CookieManager(new CustomCookieStore(), CookiePolicy.ACCEPT_ALL);
                if (!Files.exists(ElixirSwingBrowserDialogWithCookies.this.CookieStore, new LinkOption[0])) {
                    try {
                        Files.createDirectories(ElixirSwingBrowserDialogWithCookies.this.CookieStore.getParent(), new FileAttribute[0]);
                        Files.createFile(ElixirSwingBrowserDialogWithCookies.this.CookieStore, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    for (String line : Files.readAllLines(ElixirSwingBrowserDialogWithCookies.this.CookieStore)) {
                        String[] values;
                        String[] stringArray = values = line.split("~");
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String header = stringArray[n2];
                            HttpCookie cookie = CookieUtil.fromString(header);
                            if (cookie != null && !cookie.hasExpired()) {
                                manager.getCookieStore().add(new URI(header.split("|")[0]), cookie);
                            }
                            ++n2;
                        }
                    }
                }
                catch (IOException | URISyntaxException e) {
                    e.printStackTrace();
                }
                CookieHandler.setDefault(manager);
                ElixirSwingBrowserDialogWithCookies.this.engine = view.getEngine();
                ElixirSwingBrowserDialogWithCookies.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialogWithCookies.this.setTitle(newValue);
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialogWithCookies.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialogWithCookies.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialogWithCookies.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialogWithCookies.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialogWithCookies.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ElixirSwingBrowserDialogWithCookies.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                ElixirSwingBrowserDialogWithCookies.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (ElixirSwingBrowserDialogWithCookies.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(ElixirSwingBrowserDialogWithCookies.this.panel, value != null ? String.valueOf(ElixirSwingBrowserDialogWithCookies.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(ElixirSwingBrowserDialogWithCookies.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                ElixirSwingBrowserDialogWithCookies.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = ElixirSwingBrowserDialogWithCookies.toURL(url);
                if (tmp == null) {
                    tmp = ElixirSwingBrowserDialogWithCookies.toURL("http://" + url);
                }
                URI myuri = URI.create(tmp);
                LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                headers.put("Set-Cookie", Arrays.asList("name=value"));
                try {
                    CookieHandler.getDefault().put(myuri, headers);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                CookieManager man = (CookieManager)CookieHandler.getDefault();
                CookieStore store = man.getCookieStore();
                try {
                    if (!Files.exists(ElixirSwingBrowserDialogWithCookies.this.CookieStore, new LinkOption[0])) {
                        Files.createDirectories(ElixirSwingBrowserDialogWithCookies.this.CookieStore.getParent(), new FileAttribute[0]);
                        Files.createFile(ElixirSwingBrowserDialogWithCookies.this.CookieStore, new FileAttribute[0]);
                    }
                    Files.write(ElixirSwingBrowserDialogWithCookies.this.CookieStore, "".getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                    for (URI uri : store.getURIs()) {
                        for (HttpCookie cookie : store.get(uri)) {
                            if (cookie.hasExpired()) continue;
                            Files.write(ElixirSwingBrowserDialogWithCookies.this.CookieStore, (String.valueOf(uri.toString()) + "|" + CookieUtil.toString(cookie) + "~").getBytes(), StandardOpenOption.APPEND);
                        }
                    }
                    Files.write(ElixirSwingBrowserDialogWithCookies.this.CookieStore, "\n".getBytes(), StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ElixirSwingBrowserDialogWithCookies.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.setImplicitExit((boolean)false);
        ElixirSwingBrowserDialogWithCookies browser = new ElixirSwingBrowserDialogWithCookies(null, "http://www.google.de");
        browser.setVisible(true);
        ElixirSwingBrowserDialogWithCookies browser2 = new ElixirSwingBrowserDialogWithCookies(null, "http://www.google.de");
        browser2.setVisible(true);
        Platform.setImplicitExit((boolean)true);
    }
}

