/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.login;

import de.ipk_gatersleben.bit.bi.edal.primary_data.login.LoginDialog;
import java.io.IOException;
import java.util.Scanner;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LoginCallbackHandler
implements CallbackHandler {
    private String password;
    private String username;
    private boolean alreadySetted = false;

    public LoginCallbackHandler() {
    }

    public LoginCallbackHandler(String name) {
        this.username = name;
    }

    public LoginCallbackHandler(String name, String password) {
        this.username = name;
        this.password = password;
    }

    private String getConsoleString(String prompt) {
        System.out.print(prompt);
        Scanner in = new Scanner(System.in);
        String name = in.nextLine();
        in.close();
        return name;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.alreadySetted) {
            LoginDialog loginDlg = new LoginDialog(null, "Login to IPK-Domain (LDAP)", this.username);
            loginDlg.setVisible(true);
            if (loginDlg.getStatus() == 1) {
                this.username = loginDlg.getUsername();
                this.password = loginDlg.getPassword();
                this.alreadySetted = true;
            }
            if (loginDlg.getStatus() == 0) {
                this.alreadySetted = true;
            }
        }
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(this.username);
            } else if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password.toCharArray());
            }
            ++n2;
        }
    }
}

