/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.login;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwingBrowserDialog
extends JDialog {
    public static CookieManager manager;
    private static final long serialVersionUID = -3918755777891924805L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnGo = new JButton("Go");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();

    static {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Class.forName("javafx.application.Platform");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please use an Oracle_JRE to run this module", "No Oracle_JRE found", 0);
            System.exit(-1);
        }
        manager = new CookieManager();
    }

    public SwingBrowserDialog(Frame parent, String url, boolean showAdressLine, int width, int heigth) {
        super(parent, true);
        this.initComponents(parent, showAdressLine, width, heigth);
        this.loadURL(url);
    }

    public SwingBrowserDialog(Frame parent, String url) {
        super(parent, true);
        this.initComponents(parent, true, 800, 800);
        this.loadURL(url);
    }

    private void initComponents(Frame parent, boolean showAdressLine, int width, int heigth) {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingBrowserDialog.this.loadURL(SwingBrowserDialog.this.txtURL.getText());
            }
        };
        this.btnGo.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        topBar.add((Component)this.btnGo, "East");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        if (showAdressLine) {
            this.panel.add((Component)topBar, "North");
        }
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(width, heigth));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                SwingBrowserDialog.this.engine = view.getEngine();
                SwingBrowserDialog.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingBrowserDialog.this.setTitle(newValue);
                            }
                        });
                    }
                });
                SwingBrowserDialog.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingBrowserDialog.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                SwingBrowserDialog.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingBrowserDialog.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                SwingBrowserDialog.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingBrowserDialog.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                SwingBrowserDialog.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (SwingBrowserDialog.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(SwingBrowserDialog.this.panel, value != null ? String.valueOf(SwingBrowserDialog.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(SwingBrowserDialog.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                SwingBrowserDialog.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = SwingBrowserDialog.toURL(url);
                if (tmp == null) {
                    tmp = SwingBrowserDialog.toURL("http://" + url);
                }
                URI uri = URI.create(tmp);
                LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                headers.put("Set-Cookie", Arrays.asList("name=value"));
                try {
                    CookieHandler.getDefault().put(uri, headers);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingBrowserDialog.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.setImplicitExit((boolean)false);
        SwingBrowserDialog browser = new SwingBrowserDialog(null, "http://www.google.de", false, 600, 600);
        browser.setVisible(true);
        SwingBrowserDialog browser2 = new SwingBrowserDialog(null, "http://www.google.de", false, 600, 600);
        browser2.setVisible(true);
        Platform.setImplicitExit((boolean)true);
    }
}

