/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.orcid.ORCIDException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ORCID
implements Serializable {
    private static final long serialVersionUID = -2975295104009712920L;
    private String orcid;

    public ORCID(String orcid) throws ORCIDException {
        if (orcid.matches("^\\d{4}-\\d{4}-\\d{4}-\\d{3}[0-9,X]")) {
            if (!this.checkORCIDChecksum(orcid)) {
                throw new ORCIDException("Illegal ORCID '" + orcid + "': ORCID checksum wrong");
            }
        } else {
            throw new ORCIDException("Illegal ORCID '" + orcid + "': Wrong format");
        }
        this.orcid = orcid;
    }

    private boolean checkORCIDChecksum(String orcid) {
        String baseDigits = orcid.replace("-", "");
        int[] sum = new int[baseDigits.length()];
        int i = 0;
        while (i < baseDigits.length() - 1) {
            sum[i] = i == 0 ? Character.getNumericValue(baseDigits.charAt(i)) * 2 : (Character.getNumericValue(baseDigits.charAt(i)) + sum[i - 1]) * 2;
            ++i;
        }
        int remainder = sum[baseDigits.length() - 2] % 11;
        int checkDigit = (12 - remainder) % 11;
        if (checkDigit == Character.getNumericValue(baseDigits.charAt(baseDigits.length() - 1))) {
            return true;
        }
        return checkDigit == 10 && baseDigits.charAt(baseDigits.length() - 1) == 'X';
    }

    public String getOrcid() {
        return this.orcid;
    }

    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    public String toString() {
        return this.orcid;
    }

    public static ORCID getOrcidByID(String orcidString) throws ORCIDException {
        ORCIDRestConnector connector = new ORCIDRestConnector();
        connector.searchForOrcid(orcidString);
        return new ORCID(orcidString);
    }

    public static List<ORCID> getOrcidsByName(String firstName, String LastName) throws ORCIDException {
        ORCIDRestConnector connector = new ORCIDRestConnector();
        return connector.searchForName(firstName, LastName);
    }

    public static NaturalPerson getPersonByOrcid(String orcidString) throws ORCIDException {
        ORCIDRestConnector connector = new ORCIDRestConnector();
        NaturalPerson person = connector.getPersonForOrcid(orcidString);
        person.setOrcid(new ORCID(orcidString));
        return person;
    }

    private static class ORCIDRestConnector {
        private static final String CLIENT_ID = "QVBQLU9ONEgwSUcwWjYyQUJRUUI=";
        private static final String CLIENT_SECRET = "MjU3MDhjNjItZGI1Ny00NTBlLThkMmYtYjk1ZmQ3OTYzMTli";
        private static final File PATH_TO_ORCID_TOKEN = Paths.get(System.getProperty("user.home"), ".eDAL", "orcid_token.txt").toFile();
        private String accessToken = null;
        private static InetSocketAddress proxyAddress;
        private static boolean searchedForProxy;
        private ClientConfig clientConfig = null;

        static {
            searchedForProxy = false;
        }

        private ORCIDRestConnector() throws ORCIDException {
            if (!searchedForProxy) {
                proxyAddress = EdalConfiguration.guessProxySettings();
                searchedForProxy = true;
            }
            if (proxyAddress != null) {
                System.setProperty("http.proxyHost", proxyAddress.getHostName());
                System.setProperty("http.proxyPort", String.valueOf(proxyAddress.getPort()));
                System.setProperty("https.proxyHost", proxyAddress.getHostName());
                System.setProperty("https.proxyPort", String.valueOf(proxyAddress.getPort()));
                System.setProperty("java.net.useSystemProxies", "true");
                this.clientConfig = new ClientConfig();
                if (proxyAddress.isUnresolved()) {
                    this.clientConfig.property("jersey.config.client.proxy.uri", (Object)("http://" + proxyAddress.getHostName() + ":" + proxyAddress.getPort()));
                } else {
                    this.clientConfig.property("jersey.config.client.proxy.uri", (Object)(String.valueOf(proxyAddress.getHostName()) + ":" + proxyAddress.getPort()));
                }
                this.clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            }
            this.accessToken = this.loadToken() == null ? this.requestNewToken() : this.loadToken();
        }

        private String requestNewToken() throws ORCIDException {
            JerseyClient client = null;
            client = this.clientConfig == null ? JerseyClientBuilder.createClient() : JerseyClientBuilder.createClient((Configuration)this.clientConfig);
            Form input = new Form();
            input.param("client_id", new String(Base64.getDecoder().decode(CLIENT_ID)));
            input.param("client_secret", new String(Base64.getDecoder().decode(CLIENT_SECRET)));
            input.param("scope", "/read-public");
            input.param("grant_type", "client_credentials");
            JerseyWebTarget resource = client.target("https://pub.orcid.org/oauth/token");
            Response response = resource.request(new String[]{"application/json"}).post(Entity.entity((Object)input, (String)"application/x-www-form-urlencoded"));
            if (response.getStatus() == 200) {
                JSONObject jsonObject = null;
                try {
                    jsonObject = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
                }
                catch (ParseException e) {
                    throw new ORCIDException("Parsing of user token failed: " + (Object)((Object)e));
                }
                if (jsonObject.containsKey((Object)"access_token")) {
                    this.accessToken = (String)jsonObject.get((Object)"access_token");
                    try {
                        this.saveTokenToProperties(this.accessToken);
                        return this.accessToken;
                    }
                    catch (IOException iOException) {
                        throw new ORCIDException("Saving authentication token failed");
                    }
                }
            } else {
                client.close();
                throw new ORCIDException("Request for authentication token failed");
            }
            return null;
        }

        private String loadToken() {
            Properties props = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(PATH_TO_ORCID_TOKEN);
                props.load(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                return null;
            }
            if (props.containsKey("token")) {
                return props.getProperty("token");
            }
            return null;
        }

        private void saveTokenToProperties(String token) throws IOException {
            Properties props = new Properties();
            props.setProperty("token", token);
            FileOutputStream outputStream = new FileOutputStream(PATH_TO_ORCID_TOKEN);
            props.store(outputStream, "Token");
            ((OutputStream)outputStream).close();
        }

        private List<ORCID> searchForName(String givenName, String familyName) throws ORCIDException {
            givenName = givenName.replace(" ", "%20");
            familyName = familyName.replace(" ", "%20");
            JerseyClient client = null;
            client = this.clientConfig == null ? JerseyClientBuilder.createClient() : JerseyClientBuilder.createClient((Configuration)this.clientConfig);
            JerseyWebTarget resource = client.target("https://pub.orcid.org/v2.0/search/?q=given-names:" + givenName + "+AND+family-name:" + familyName);
            Response response = resource.request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get();
            try {
                if (response.getStatus() == 200) {
                    String result = (String)response.readEntity(String.class);
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(result)));
                    NodeList list = document.getElementsByTagName("search:result");
                    if (list.getLength() == 1) {
                        ArrayList<ORCID> orcids = new ArrayList<ORCID>(1);
                        orcids.add(new ORCID(document.getElementsByTagName("common:path").item(0).getTextContent()));
                        return orcids;
                    }
                    if (list.getLength() > 1) {
                        ArrayList<ORCID> orchids = new ArrayList<ORCID>(list.getLength() - 1);
                        int i = 0;
                        while (i < list.getLength()) {
                            Element e = (Element)list.item(i);
                            orchids.add(new ORCID(e.getElementsByTagName("common:path").item(0).getTextContent()));
                            ++i;
                        }
                        return orchids;
                    }
                    return new ArrayList<ORCID>(0);
                }
                client.close();
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                throw new ORCIDException("Unable ro request ORCID API");
            }
            return null;
        }

        private void searchForOrcid(String orcid) throws ORCIDException {
            block4: {
                JerseyClient client = null;
                client = this.clientConfig == null ? JerseyClientBuilder.createClient() : JerseyClientBuilder.createClient((Configuration)this.clientConfig);
                JerseyWebTarget resource = client.target("https://pub.orcid.org/search/orcid-bio/?q=orcid:" + orcid);
                Response response = (Response)resource.request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get(Response.class);
                if (response.getStatus() == 200) {
                    String result = (String)response.readEntity(String.class);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document document = builder.parse(new InputSource(new StringReader(result)));
                        NodeList list = document.getElementsByTagName("orcid-search-results");
                        if (!list.item(0).getAttributes().getNamedItem("num-found").getNodeValue().equals("1")) {
                            throw new ORCIDException("no orcid registered");
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        throw new ORCIDException("no orcid registered", e);
                    }
                }
                client.close();
            }
        }

        private NaturalPerson getPersonForOrcid(String orcid) throws ORCIDException {
            JerseyClient client = null;
            client = this.clientConfig == null ? JerseyClientBuilder.createClient() : JerseyClientBuilder.createClient((Configuration)this.clientConfig);
            JerseyWebTarget resource = client.target("https://pub.orcid.org/v2.0/" + orcid + "/personal-details");
            Response response = resource.request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get();
            if (response.getStatus() == 200) {
                String result = (String)response.readEntity(String.class);
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(result)));
                    Node foundedGivenName = document.getElementsByTagName("personal-details:given-names").item(0);
                    Node foundedfamilyName = document.getElementsByTagName("personal-details:family-name").item(0);
                    if (foundedGivenName != null && foundedfamilyName != null) {
                        return new NaturalPerson(foundedGivenName.getTextContent(), foundedfamilyName.getTextContent(), "", "", "");
                    }
                    throw new ORCIDException("no orcid registered");
                }
                catch (Exception e) {
                    throw new ORCIDException("no orcid registered", e);
                }
            }
            client.close();
            return null;
        }
    }
}

