/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.orcid;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ORCIDConnector {
    private static final String CLIENT_ID = "QVBQLU9ONEgwSUcwWjYyQUJRUUI=";
    private static final String CLIENT_SECRET = "MjU3MDhjNjItZGI1Ny00NTBlLThkMmYtYjk1ZmQ3OTYzMTli";
    private static final File PATH_TO_ORCID_TOKEN;
    private String accessToken = this.loadToken() == null ? this.requestNewToken() : this.loadToken();
    private String orcid = null;
    private String givenName = null;
    private String familyName = null;
    private String affiliation = null;

    static {
        InetSocketAddress proxy = EdalConfiguration.guessProxySettings();
        System.setProperty("http.proxyHost", proxy.getHostName());
        System.setProperty("http.proxyPort", String.valueOf(proxy.getPort()));
        System.setProperty("https.proxyHost", proxy.getHostName());
        System.setProperty("https.proxyPort", String.valueOf(proxy.getPort()));
        System.setProperty("java.net.useSystemProxies", "true");
        PATH_TO_ORCID_TOKEN = Paths.get(System.getProperty("user.home"), ".eDAL", "orcid_token.txt").toFile();
    }

    public static final List<String> getORCIDForName() {
        return null;
    }

    public ORCIDConnector(String orcid) throws Exception {
        this.getNameByOrcid(orcid);
        this.getCurrentAffiliationByOrcid(orcid);
        this.orcid = orcid;
    }

    public ORCIDConnector(String givenName, String familyName) throws Exception {
        this.searchForName(givenName, familyName);
    }

    public ORCIDConnector(String givenName, String familyName, String affiliation) throws Exception {
        this.searchForAffiliation(givenName, familyName, affiliation);
    }

    public String toString() {
        return "GivenName: " + this.givenName + "\t" + "FamilyName: " + this.familyName + "\t" + "(" + this.orcid + ") (" + this.affiliation + ")";
    }

    private String requestNewToken() throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        Form input = new Form();
        input.param("client_id", new String(Base64.getDecoder().decode(CLIENT_ID)));
        input.param("client_secret", new String(Base64.getDecoder().decode(CLIENT_SECRET)));
        input.param("scope", "/read-public");
        input.param("grant_type", "client_credentials");
        JerseyWebTarget resource = client.target("https://pub.orcid.org/oauth/token");
        Response response = resource.request(new String[]{"application/json"}).post(Entity.entity((Object)input, (String)"application/x-www-form-urlencoded"));
        if (response.getStatus() == 200) {
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
            }
            catch (ParseException e) {
                throw new Exception("Parsing of user token failed: " + (Object)((Object)e));
            }
            if (jsonObject.containsKey((Object)"access_token")) {
                this.accessToken = (String)jsonObject.get((Object)"access_token");
                try {
                    this.saveTokenToProperties(this.accessToken);
                    return this.accessToken;
                }
                catch (IOException iOException) {
                    throw new Exception("Saving authentication token failed");
                }
            }
        } else {
            client.close();
            throw new Exception("Request for authentication token failed");
        }
        return null;
    }

    private String loadToken() {
        Properties props = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(PATH_TO_ORCID_TOKEN);
            props.load(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (props.containsKey("token")) {
            return props.getProperty("token");
        }
        return null;
    }

    private void saveTokenToProperties(String token) throws IOException {
        Properties props = new Properties();
        props.setProperty("token", token);
        FileOutputStream outputStream = new FileOutputStream(PATH_TO_ORCID_TOKEN);
        props.store(outputStream, "Token");
        ((OutputStream)outputStream).close();
    }

    private void getNameByOrcid(String orcid) throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        JerseyWebTarget resource = client.target("https://pub.orcid.org/v2.0/" + orcid + "/personal-details");
        Response response = resource.request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get();
        if (response.getStatus() == 200) {
            String result = (String)response.readEntity(String.class);
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(result)));
                Node foundedGivenName = document.getElementsByTagName("personal-details:given-names").item(0);
                Node foundedfamilyName = document.getElementsByTagName("personal-details:family-name").item(0);
                if (foundedGivenName == null || foundedfamilyName == null) {
                    throw new Exception("no personal data founded");
                }
                this.givenName = foundedGivenName.getTextContent();
                this.familyName = foundedfamilyName.getTextContent();
            }
            catch (Exception e) {
                throw new Exception("no orcid registered", e);
            }
        } else {
            client.close();
        }
    }

    private void getCurrentAffiliationByOrcid(String orcid) throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        JerseyWebTarget resource = client.target("https://pub.orcid.org/v2.0/" + orcid + "/employments");
        Response response = resource.request(new String[]{"application/vnd.orcid+xml "}).header("Authorization", (Object)("Bearer " + this.accessToken)).get();
        if (response.getStatus() == 200) {
            String result = (String)response.readEntity(String.class);
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(result)));
                NodeList list = document.getElementsByTagName("employment:employment-summary");
                if (list.getLength() == 1) {
                    this.affiliation = document.getElementsByTagName("common:name").item(0).getTextContent();
                }
                int i = 0;
                while (i < list.getLength()) {
                    Element element = (Element)list.item(i);
                    if (element.getElementsByTagName("common:end-date").getLength() != 1) {
                        this.affiliation = element.getElementsByTagName("common:name").item(0).getTextContent();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new Exception("no orcid registered", e);
            }
        } else {
            client.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void searchForName(String givenName, String familyName) throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        JerseyWebTarget resource = client.target("https://pub.orcid.org/v2.0/search/?q=given-names:" + givenName + "+AND+family-name:" + familyName);
        Response response = resource.request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get();
        if (response.getStatus() != 200) {
            client.close();
            return;
        }
        String result = (String)response.readEntity(String.class);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(result)));
        NodeList list = document.getElementsByTagName("search:result");
        if (list.getLength() == 1) {
            this.givenName = givenName;
            this.familyName = familyName;
            this.orcid = document.getElementsByTagName("common:path").item(0).getTextContent();
            this.getCurrentAffiliationByOrcid(this.orcid);
            return;
        }
        if (list.getLength() <= 1) throw new Exception("no orcid registered");
        throw new Exception("find more than one ORCID with the given name");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void searchForAffiliation(String givenName, String familyName, String affiliation) throws Exception {
        JerseyWebTarget resource;
        Response response;
        JerseyClient client = JerseyClientBuilder.createClient();
        String query = "";
        if (givenName != null && givenName != "") {
            query = query.length() > 0 ? String.valueOf(query) + "+AND+given-names:" + givenName : String.valueOf(query) + "given-names:" + givenName;
        }
        if (familyName != null && familyName != "") {
            query = query.length() > 0 ? String.valueOf(query) + "+AND+family-name:" + familyName : String.valueOf(query) + "family-name:" + familyName;
        }
        if (affiliation != null && affiliation != "") {
            query = query.length() > 0 ? String.valueOf(query) + "+AND+affiliation-org-name:" + affiliation : String.valueOf(query) + "affiliation-org-name:" + affiliation;
        }
        if ((response = (resource = client.target("https://pub.orcid.org/search/orcid-bio/?q=" + query)).request(new String[]{"application/orcid+xml"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get()).getStatus() != 200) {
            client.close();
            return;
        }
        String result = (String)response.readEntity(String.class);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(result)));
        NodeList list = document.getElementsByTagName("orcid-search-results");
        if (Integer.valueOf(list.item(0).getAttributes().getNamedItem("num-found").getNodeValue()) == 1) {
            this.givenName = document.getElementsByTagName("given-names").item(0).getTextContent();
            this.familyName = document.getElementsByTagName("family-name").item(0).getTextContent();
            this.orcid = document.getElementsByTagName("orcid-identifier").item(0).getChildNodes().item(3).getTextContent();
            return;
        }
        if (Integer.valueOf(list.item(0).getAttributes().getNamedItem("num-found").getNodeValue()) <= 1) throw new Exception("no orcid registered");
        throw new Exception("find more than one ORCID with the given name: " + Integer.valueOf(list.item(0).getAttributes().getNamedItem("num-found").getNodeValue()));
    }
}

