/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.XmlFunctions;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.w3c.dom.Document;

public class DataCiteMDSConnector {
    private static final String DOI_URL = "https://mds.datacite.org/doi";
    private static final String METADATA_URL = "https://mds.datacite.org/metadata";
    private static final String DOI_TEST_URL = "https://mds.test.datacite.org/doi";
    private static final String METADATA_TEST_URL = "https://mds.test.datacite.org/metadata";
    private static final int GOOD_RESPONSE = 201;
    private static String dataCiteUser = "";
    private static String dataCitePassword = "";
    private static String dataCiteTestUser = "TIB";
    private static String dataCiteTestPassword = "edal0815";
    private String prefix = "";
    private static boolean testModus = false;
    private WebTarget webTarget = null;
    private final JerseyClient dataCiteClient;

    public DataCiteMDSConnector(EdalConfiguration configuration) throws EdalException {
        HttpAuthenticationFeature feature;
        if (configuration.isUseSystemProxies()) {
            try {
                System.setProperty("http.proxyHost", configuration.getHttpProxyHost());
                System.setProperty("http.proxyPort", String.valueOf(configuration.getHttpProxyPort()));
                System.setProperty("https.proxyHost", configuration.getHttpsProxyHost());
                System.setProperty("https.proxyPort", String.valueOf(configuration.getHttpsProxyPort()));
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (EdalConfigurationException e) {
                throw new EdalException(e);
            }
        }
        if (configuration.isInTestMode()) {
            testModus = true;
            this.dataCiteClient = JerseyClientBuilder.createClient();
            feature = HttpAuthenticationFeature.basicBuilder().nonPreemptive().credentials(dataCiteTestUser, dataCiteTestPassword).build();
            this.dataCiteClient.register((Object)feature);
        } else {
            try {
                dataCiteUser = configuration.getDataCiteUser();
                dataCitePassword = configuration.getDataCitePassword();
            }
            catch (EdalConfigurationException e) {
                throw new EdalException("unable to init Configuration : " + e.getMessage(), e);
            }
            this.dataCiteClient = JerseyClientBuilder.createClient();
            feature = HttpAuthenticationFeature.basicBuilder().nonPreemptive().credentials(dataCiteUser, dataCitePassword).build();
            this.dataCiteClient.register((Object)feature);
        }
        try {
            this.prefix = configuration.getDataCitePrefix();
        }
        catch (EdalConfigurationException e) {
            throw new EdalException("unable to load DataCite Prefix", e);
        }
    }

    public Response getDOI(String doi) {
        this.webTarget = testModus ? this.dataCiteClient.target(DOI_TEST_URL) : this.dataCiteClient.target(DOI_URL);
        Response response = this.webTarget.path("/" + doi).request(new String[]{"text/html"}).get();
        return response;
    }

    public Response getMetadata(String doi) {
        this.webTarget = testModus ? this.dataCiteClient.target(METADATA_TEST_URL) : this.dataCiteClient.target(METADATA_URL);
        Response response = this.webTarget.path("/" + doi).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get();
        return response;
    }

    public Response postDOI(String doi, String url) throws DataCiteException {
        Response response;
        String requestBody;
        this.webTarget = testModus ? this.dataCiteClient.target(DOI_TEST_URL) : this.dataCiteClient.target(DOI_URL);
        String newRequestbody = requestBody = "doi=" + doi + "\r\n" + "url=" + url;
        if (requestBody.contains("bit-252")) {
            newRequestbody = requestBody.replace("bit-252", "doi");
        }
        if ((response = this.webTarget.request(new String[]{MediaType.TEXT_PLAIN_TYPE + ";charset=utf-8"}).post(Entity.entity((Object)newRequestbody, (String)(MediaType.TEXT_PLAIN_TYPE + ";charset=utf-8")))).getStatus() != 201) {
            throw new DataCiteException(response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    public Response postMetadata(Document xml) throws DataCiteException {
        this.webTarget = testModus ? this.dataCiteClient.target(METADATA_TEST_URL) : this.dataCiteClient.target(METADATA_URL);
        String requestBody = XmlFunctions.toString(xml);
        Response response = this.webTarget.request(new String[]{MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"}).post(Entity.entity((Object)requestBody, (String)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8")));
        if (response.getStatus() != 201) {
            throw new DataCiteException(response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    public int getNextFreeDOI(int year, int startDoi, String datacentre) {
        this.webTarget = testModus ? this.dataCiteClient.target(DOI_TEST_URL) : this.dataCiteClient.target(DOI_URL);
        boolean isDoiFree = false;
        while (!isDoiFree) {
            Response response = this.webTarget.path("/" + this.prefix + "/" + datacentre + "/" + year + "/" + String.valueOf(startDoi)).request(new String[]{"text/html"}).get();
            if (response.getStatus() != 200) break;
            ++startDoi;
        }
        return startDoi;
    }
}

