/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.DataCiteMDSConnector;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DataCiteRestConnector {
    private String prefix = "";
    private JerseyClient restClient = null;
    private WebTarget webTarget = null;
    private EdalConfiguration configuration = null;

    public DataCiteRestConnector(EdalConfiguration configuration) throws DataCiteException {
        this.configuration = configuration;
        if (configuration.isUseSystemProxies()) {
            try {
                System.setProperty("http.proxyHost", configuration.getHttpProxyHost());
                System.setProperty("http.proxyPort", String.valueOf(configuration.getHttpProxyPort()));
                System.setProperty("https.proxyHost", configuration.getHttpsProxyHost());
                System.setProperty("https.proxyPort", String.valueOf(configuration.getHttpsProxyPort()));
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (EdalConfigurationException e) {
                throw new DataCiteException(e);
            }
        }
        try {
            this.prefix = configuration.getDataCitePrefix();
        }
        catch (EdalConfigurationException e) {
            throw new DataCiteException("unable to load DataCite Prefix", e);
        }
    }

    private String getDataCentreIdForPrefix(String prefix) throws DataCiteException {
        this.restClient = JerseyClientBuilder.createClient();
        this.webTarget = this.restClient.target("https://api.datacite.org/prefixes/" + prefix);
        Response response = this.webTarget.request(new String[]{"application/json"}).get();
        if (response.getStatus() == 200) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
                JSONArray included = (JSONArray)json.get((Object)"included");
                JSONObject relationships = (JSONObject)included.get(0);
                JSONObject attributes = (JSONObject)relationships.get((Object)"attributes");
                String dataCentreString = (String)attributes.get((Object)"symbol");
                return dataCentreString;
            }
            catch (NullPointerException | ParseException e) {
                throw new DataCiteException("unable to query the data centre ID", e);
            }
        }
        this.restClient.close();
        throw new DataCiteException("unable to query the data centre ID");
    }

    public String generateNewDOI(int year) throws DataCiteException {
        try {
            if (this.configuration.getDoiInfix() != null) {
                DataCiteMDSConnector connector = new DataCiteMDSConnector(this.configuration);
                int nextFreeDoiNumber = connector.getNextFreeDOI(year, 0, this.configuration.getDoiInfix());
                return String.valueOf(this.prefix) + "/" + this.configuration.getDoiInfix() + "/" + year + "/" + nextFreeDoiNumber;
            }
            DataCiteMDSConnector connector = new DataCiteMDSConnector(this.configuration);
            String dataCentreString = this.getDataCentreIdForPrefix(this.prefix);
            String dataCentreName = dataCentreString.substring(dataCentreString.indexOf(".") + 1, dataCentreString.length());
            int nextFreeDoiNumber = connector.getNextFreeDOI(year, this.getNumberOfResolvableDOIsByPrefix(year, this.prefix), dataCentreName);
            return String.valueOf(this.prefix) + "/" + dataCentreName + "/" + year + "/" + nextFreeDoiNumber;
        }
        catch (EdalException e) {
            throw new DataCiteException("unable to get number of stored DOIs", e);
        }
    }

    private int getNumberOfResolvableDOIsByPrefix(int year, String prefix) throws DataCiteException {
        this.restClient = JerseyClientBuilder.createClient();
        this.webTarget = this.restClient.target("https://api.datacite.org/works?query=prefix:" + prefix + "&registered=" + year + "&page[size]=999");
        Response response = this.webTarget.request(new String[]{"application/json"}).get();
        if (response.getStatus() == 200) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
                JSONArray data = (JSONArray)json.get((Object)"data");
                return data.size();
            }
            catch (NullPointerException | ParseException e) {
                throw new DataCiteException("unable to query the number of stored DOIs", e);
            }
        }
        this.restClient.close();
        throw new DataCiteException("unable to query the number of stored DOIs");
    }

    public boolean checkIfPrefixIsRegisteredForDataCenterId() {
        this.restClient = JerseyClientBuilder.createClient();
        this.webTarget = this.restClient.target("https://api.datacite.org/prefixes/" + this.prefix);
        Response response = this.webTarget.request(new String[]{"application/json"}).get();
        if (response.getStatus() == 200) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
                JSONArray included = (JSONArray)json.get((Object)"included");
                JSONObject relationships = (JSONObject)included.get(0);
                JSONObject attributes = (JSONObject)relationships.get((Object)"attributes");
                String dataCentreString = (String)attributes.get((Object)"symbol");
                return dataCentreString.toLowerCase().equals(this.configuration.getDataCiteUser().toLowerCase());
            }
            catch (EdalConfigurationException | NullPointerException | ParseException throwable) {
                return false;
            }
        }
        this.restClient.close();
        return false;
    }
}

