/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFunctions {
    public static Document parse(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        StringReader stringReader = new StringReader(xmlString);
        InputSource inputSource = new InputSource(stringReader);
        Document document = null;
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            document = builder.parse(inputSource);
            document.normalizeDocument();
        }
        catch (ParserConfigurationException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
        }
        catch (SAXException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
        }
        return document;
    }

    public static Document parse(File xmlFile) {
        try {
            return XmlFunctions.parse(XmlFunctions.getFileAsString(xmlFile));
        }
        catch (IOException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
            return null;
        }
    }

    private static String getFileAsString(File filename) throws IOException {
        try {
            String line;
            StringBuffer content = new StringBuffer();
            String lineFeed = System.getProperty("line.separator");
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                content.append(line).append(lineFeed);
            }
            in.close();
            return content.toString();
        }
        catch (IOException iOException) {
            throw new IOException("unable to read from file: " + filename);
        }
    }

    public static String toString(Document document) {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document.getDocumentElement()), streamResult);
        }
        catch (TransformerConfigurationException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
        }
        catch (TransformerException e) {
            DataManager.getImplProv().getLogger().error(e.getMessage());
        }
        return stringWriter.toString();
    }

    public static void validate(URL schemaFile, Document xmlDocument) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaFile);
        schema.newValidator().validate(new DOMSource(xmlDocument));
    }
}

