/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.XmlNameIdentifier;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.datacite.xml.types.ContributorType;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="contributor", propOrder={"contributorName", "givenName", "familyName", "nameIdentifier", "affiliation"})
public class XmlContributor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContributorType contributorType;
    private String contributorName;
    private XmlNameIdentifier nameIdentifier;
    private String givenName;
    private String familyName;
    private String affiliation;

    public XmlContributor() {
    }

    public XmlContributor(String contributorName) {
        this();
        this.setContributorName(contributorName);
    }

    public XmlContributor(String contributorName, ContributorType contributorType) {
        this(contributorName);
        this.setContributorType(contributorType);
    }

    public XmlContributor(Person person) {
        this();
        if (person instanceof NaturalPerson) {
            NaturalPerson np = (NaturalPerson)person;
            this.setContributorName(String.valueOf(np.getSureName()) + ", " + np.getGivenName());
            this.setContributorType(ContributorType.Researcher);
            this.setGivenName(np.getGivenName());
            this.setFamilyName(np.getSureName());
            this.setAffiliation(String.valueOf(np.getAddressLine()) + ", " + np.getZip() + ", " + np.getCountry());
            if (np.getOrcid() != null) {
                this.setNameIdentifier(new XmlNameIdentifier(np.getOrcid().getOrcid(), "ORCID", "http://orcid.org/"));
            }
        } else if (person instanceof LegalPerson) {
            LegalPerson lp = (LegalPerson)person;
            this.setContributorName(lp.getLegalName());
            this.setContributorType(ContributorType.ResearchGroup);
            this.setAffiliation(String.valueOf(lp.getAddressLine()) + ", " + lp.getZip() + ", " + lp.getCountry());
        }
    }

    @XmlElement(required=true)
    public String getContributorName() {
        return this.contributorName;
    }

    @XmlAttribute
    public ContributorType getContributorType() {
        return this.contributorType;
    }

    @XmlElement
    public XmlNameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setContributorName(String contributorName) {
        this.contributorName = contributorName;
    }

    public void setContributorType(ContributorType contributorType) {
        this.contributorType = contributorType;
    }

    public void setNameIdentifier(XmlNameIdentifier nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }

    @XmlElement
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @XmlElement
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @XmlElement
    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }
}

