/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review;

import de.ipk_gatersleben.bit.bi.edal.primary_data.DataManager;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfigurationException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.EdalApprovalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewResult;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewStatus;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.review.ReviewStatusEvaluation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewProcess {
    static final int DEFAULT_TIMEOUT = 182;
    protected static ReviewStatusEvaluation evaluationForGroups;
    protected static ReviewStatusEvaluation evaluationForDataManager;

    static {
        try {
            evaluationForGroups = ReviewStatusEvaluation.createReviewStatusEvaluationForGroups();
            evaluationForDataManager = ReviewStatusEvaluation.createReviewStatusEvaluationForDatamanager();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        $SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$reference$review$ReviewStatus$ReviewerType = ReviewProcess.$SWITCH_TABLE$de$ipk_gatersleben$bit$bi$edal$primary_data$reference$review$ReviewStatus$ReviewerType();
    }

    protected static List<ReviewStatus> createNewReviewResult() throws EdalApprovalException {
        try {
            ReviewStatus scientificReviewStatus = new ReviewStatus();
            scientificReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerScientific());
            scientificReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
            scientificReviewStatus.setRequestedDate(Calendar.getInstance());
            scientificReviewStatus.setReviewerType(ReviewStatus.ReviewerType.SCIENTIFIC);
            ReviewStatus substituteReviewStatus = new ReviewStatus();
            substituteReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerSubstitute());
            substituteReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
            substituteReviewStatus.setRequestedDate(Calendar.getInstance());
            substituteReviewStatus.setReviewerType(ReviewStatus.ReviewerType.SUBSTITUTE);
            ReviewStatus managingReviewStatus = new ReviewStatus();
            managingReviewStatus.setEmailAddress(DataManager.getConfiguration().getReviewerManaging());
            managingReviewStatus.setStatusType(ReviewStatus.ReviewStatusType.UNDECIDED);
            managingReviewStatus.setRequestedDate(Calendar.getInstance());
            managingReviewStatus.setReviewerType(ReviewStatus.ReviewerType.MANAGING);
            return Arrays.asList(scientificReviewStatus, substituteReviewStatus, managingReviewStatus);
        }
        catch (EdalConfigurationException e) {
            throw new EdalApprovalException(e);
        }
    }

    private static boolean isTimeoutExceeded(Calendar requestedDate) {
        Calendar now = Calendar.getInstance();
        long difference = (now.getTimeInMillis() - requestedDate.getTimeInMillis()) / 86400000L;
        return difference > 182L;
    }

    public static ReviewResult review(List<ReviewStatus> reviewStatusList) throws EdalApprovalException {
        ReviewStatus scientificReviewStatus = null;
        ReviewStatus substituteReviewStatus = null;
        ReviewStatus managingReviewStatus = null;
        ReviewResult reviewResult = new ReviewResult();
        if (reviewStatusList.size() == 0) {
            reviewStatusList = ReviewProcess.createNewReviewResult();
        }
        if (reviewStatusList.size() != 3) {
            throw new EdalApprovalException("Unexpected reviewStatusList size. Expected was 3 but list size is: " + reviewStatusList.size() + ".");
        }
        for (ReviewStatus reviewStatus : reviewStatusList) {
            if (reviewStatus.getStatusType() == ReviewStatus.ReviewStatusType.UNDECIDED && ReviewProcess.isTimeoutExceeded(reviewStatus.getRequestedDate())) {
                reviewStatus.setStatusType(ReviewStatus.ReviewStatusType.TIMEOUT);
            }
            switch (reviewStatus.getReviewerType()) {
                case SCIENTIFIC: {
                    scientificReviewStatus = reviewStatus;
                    break;
                }
                case SUBSTITUTE: {
                    substituteReviewStatus = reviewStatus;
                    break;
                }
                case MANAGING: {
                    managingReviewStatus = reviewStatus;
                }
            }
        }
        reviewResult.setReviewResult(evaluationForDataManager.eval((Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>)new ImmutablePair((Object)evaluationForGroups.eval((Pair<ReviewStatus.ReviewStatusType, ReviewStatus.ReviewStatusType>)new ImmutablePair((Object)scientificReviewStatus.getStatusType(), (Object)substituteReviewStatus.getStatusType())), (Object)managingReviewStatus.getStatusType())));
        reviewResult.setReviewerStatusList(reviewStatusList);
        return reviewResult;
    }
}

