/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.ImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.implementation.FileSystemImplementationProvider;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.EdalLoginConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.ElixirCallBackHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.GoogleCallBackHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.LoginCallbackHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.ORCIDCallBackHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.login.UserCallBackHandler;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import javafx.application.Platform;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.lang3.SystemUtils;
import org.hibernate.stat.CacheRegionStatistics;
import org.hibernate.stat.Statistics;

public class EdalHelpers {
    static {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Class.forName("javafx.application.Platform");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please use an Oracle_JRE to run this module", "No Oracle_JRE found", 0);
            System.exit(-1);
        }
    }

    public static Subject authenticateGoogleUser() throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithGoogle("Google", "", 0);
    }

    public static Subject authenticateORCIDUser(String httpProxyHost, int httpProxyPort) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithORCID("ORCID", httpProxyHost, httpProxyPort);
    }

    public static Subject authenticateElixirUser(String httpProxyHost, int httpProxyPort) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithElixir("Elixir", httpProxyHost, httpProxyPort);
    }

    private static Subject authenticateSubjectWithElixir(String loginModule, String httpProxyHost, int httpProxyPort) {
        Configuration.setConfiguration(new EdalLoginConfiguration());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EdalHelpers.class.getClassLoader());
        LoginContext ctx = null;
        boolean retry = true;
        Platform.setImplicitExit((boolean)false);
        while (retry) {
            try {
                ctx = new LoginContext(loginModule, new ElixirCallBackHandler(httpProxyHost, httpProxyPort));
                ctx.login();
                retry = false;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return ctx.getSubject();
            }
            catch (LoginException e) {
                int result = 0;
                result = e.getCause() == null ? Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: no null name allowed\nTry again ?", "Login to Elixir", 0)).intValue() : Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: " + e.getMessage() + "\nTry again ?", "Login to Elixir+", 0)).intValue();
                if (result == 0) {
                    retry = true;
                    continue;
                }
                if (result != 1) continue;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return null;
            }
        }
        Platform.setImplicitExit((boolean)true);
        return null;
    }

    public static Subject authenticateGoogleUser(String httpProxyHost, int httpProxyPort) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithGoogle("Google", httpProxyHost, httpProxyPort);
    }

    private static Subject authenticateSubjectWithGoogle(String loginModule, String httpProxyHost, int httpProxyPort) {
        Configuration.setConfiguration(new EdalLoginConfiguration());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EdalHelpers.class.getClassLoader());
        LoginContext ctx = null;
        boolean retry = true;
        Platform.setImplicitExit((boolean)false);
        while (retry) {
            try {
                ctx = new LoginContext(loginModule, new GoogleCallBackHandler(httpProxyHost, httpProxyPort));
                ctx.login();
                retry = false;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return ctx.getSubject();
            }
            catch (LoginException e) {
                int result = 0;
                result = e.getCause() == null ? Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: no null name allowed\nTry again ?", "Login to Google+", 0)).intValue() : Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: " + e.getMessage() + "\nTry again ?", "Login to Google+", 0)).intValue();
                if (result == 0) {
                    retry = true;
                    continue;
                }
                if (result != 1) continue;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return null;
            }
        }
        Platform.setImplicitExit((boolean)true);
        return null;
    }

    private static Subject authenticateSubjectWithORCID(String loginModule, String httpProxyHost, int httpProxyPort) {
        Configuration.setConfiguration(new EdalLoginConfiguration());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EdalHelpers.class.getClassLoader());
        LoginContext ctx = null;
        boolean retry = true;
        Platform.setImplicitExit((boolean)false);
        while (retry) {
            try {
                ctx = new LoginContext(loginModule, new ORCIDCallBackHandler(httpProxyHost, httpProxyPort));
                ctx.login();
                retry = false;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return ctx.getSubject();
            }
            catch (LoginException e) {
                int result = 0;
                result = e.getCause() == null ? Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: no null name allowed\nTry again ?", "Login to ORCID", 0)).intValue() : Integer.valueOf(JOptionPane.showConfirmDialog(null, "Your login attempt was not successful !\nReason: " + e.getMessage() + "\nTry again ?", "Login to ORCDI", 0)).intValue();
                if (result == 0) {
                    retry = true;
                    continue;
                }
                if (result != 1) continue;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                Platform.setImplicitExit((boolean)true);
                return null;
            }
        }
        Platform.setImplicitExit((boolean)true);
        return null;
    }

    public static Subject authenticateIPKKerberosUser(String user) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubjectWithKerberos("IPK-GATERSLEBEN.DE", "auth1.ipk-gatersleben.de", user);
    }

    public static Subject authenticateUser(String name, String password) throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubject("User", new UserCallBackHandler(name, password));
    }

    public static Subject authenticateSampleUser() throws EdalAuthenticateException {
        return EdalHelpers.authenticateSubject("Sample", null);
    }

    private static Subject authenticateSubject(String loginModule, CallbackHandler callbackhandler) throws EdalAuthenticateException {
        Configuration.setConfiguration(new EdalLoginConfiguration());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EdalHelpers.class.getClassLoader());
        LoginContext ctx = null;
        try {
            ctx = callbackhandler == null ? new LoginContext(loginModule) : new LoginContext(loginModule, callbackhandler);
            ctx.login();
        }
        catch (LoginException e) {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            throw new EdalAuthenticateException("can't login using LoginModule", e);
        }
        Thread.currentThread().setContextClassLoader(currentClassLoader);
        return ctx.getSubject();
    }

    public static Subject authenticateSubjectWithKerberos(String kerberosRealm, String kerberosKDC, String user) throws EdalAuthenticateException {
        Configuration.setConfiguration(new EdalLoginConfiguration());
        System.setProperty("java.security.krb5.realm", kerberosRealm);
        System.setProperty("java.security.krb5.kdc", kerberosKDC);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EdalHelpers.class.getClassLoader());
        LoginContext ctx = null;
        boolean retry = true;
        while (retry) {
            try {
                ctx = new LoginContext("Kerberos", new LoginCallbackHandler(user));
                ctx.login();
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                retry = false;
                return ctx.getSubject();
            }
            catch (Exception e) {
                if (e.getCause() == null) {
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                    return null;
                }
                int result = 0;
                if (e.getCause() instanceof UnknownHostException) {
                    result = JOptionPane.showConfirmDialog(null, "Your login attempt was not successful, try again? \nReason: Can not connect to LDAP-Provider,\nplease check your network/VPN configuration", "Login to IPK-Domain (LDAP)", 0);
                }
                if (result == 0) {
                    retry = true;
                    continue;
                }
                if (result != true) continue;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                retry = false;
                return null;
            }
        }
        return null;
    }

    public static Subject authenticateWinOrUnixOrMacUser() throws EdalAuthenticateException {
        if (SystemUtils.IS_OS_UNIX) {
            return EdalHelpers.authenticateSubject("Unix", null);
        }
        if (SystemUtils.IS_OS_MAC) {
            return EdalHelpers.authenticateSubject("Unix", null);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return EdalHelpers.authenticateSubject("Windows", null);
        }
        throw new EdalAuthenticateException("You do not use a Windows or Unix or MAC OS !");
    }

    public static void cleanMountPath(Path path) throws EdalException {
        try {
            EdalHelpers.deleteDirectory(path);
        }
        catch (EdalException e) {
            throw new EdalException("Can not clean mount path: " + e.getMessage());
        }
    }

    private static void deleteDirectory(Path directory) throws EdalException {
        block8: {
            try {
                if (Files.exists(directory, new LinkOption[0])) {
                    FileDeleteStrategy.FORCE.delete(directory.toFile());
                }
            }
            catch (IOException e) {
                System.gc();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (Files.exists(directory, new LinkOption[0])) {
                        FileDeleteStrategy.FORCE.delete(directory.toFile());
                    }
                }
                catch (IOException iOException) {
                    if (e.getCause() == null) break block8;
                    throw new EdalException("could not delete directory: " + e.getCause());
                }
            }
        }
    }

    @Deprecated
    private static void deleteDir(Path directory) throws EdalException {
        if (Files.exists(directory, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                        if (exception == null) {
                            while (dir.toFile().delete()) {
                                1 var3_3 = this;
                                synchronized (var3_3) {
                                    try {
                                        this.wait(10L);
                                    }
                                    catch (InterruptedException e) {
                                        throw new IOException("could not wait to delete file: " + e.getMessage(), e);
                                    }
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        throw exception;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        while (file.toFile().delete()) {
                            1 var3_3 = this;
                            synchronized (var3_3) {
                                try {
                                    this.wait(10L);
                                }
                                catch (InterruptedException e) {
                                    throw new IOException("could not wait to delete file: " + e.getMessage(), e);
                                }
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new EdalException("could not delete file: " + e.getMessage());
            }
        }
    }

    public static ImplementationProvider getFileSystemImplementationProvider(boolean cleanMountPathBefore, EdalConfiguration config) throws EdalException {
        if (cleanMountPathBefore) {
            try {
                EdalHelpers.cleanMountPath(config.getMountPath());
                EdalHelpers.cleanMountPath(config.getDataPath());
            }
            catch (EdalException e) {
                throw new EdalException("Can not clean mount path before starting eDAL: " + e.getMessage(), e);
            }
        }
        if (Files.notExists(config.getMountPath(), LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(config.getMountPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new EdalException("Can not create mount path before starting eDAL: " + e.getMessage(), e);
            }
        }
        if (Files.notExists(config.getDataPath(), LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(config.getDataPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new EdalException("Can not create data path before start eDAL: " + e.getMessage(), e);
            }
        }
        FileSystemImplementationProvider mountPoint = new FileSystemImplementationProvider(config);
        return mountPoint;
    }

    public static void getSearchStatistic(Statistics statistics) {
        try {
            if (!statistics.isStatisticsEnabled()) {
                System.out.println("WARN: statistics disabled");
            }
            System.out.println("\n******** Search-Statistic ********");
            CacheRegionStatistics metaDataStatistics = null;
            try {
                metaDataStatistics = statistics.getDomainDataRegionStatistics("search.metadata");
                long metaDataHit = metaDataStatistics.getHitCount();
                long metaDataMiss = metaDataStatistics.getMissCount();
                double metaDataRatio = (double)metaDataHit / (double)(metaDataHit + metaDataMiss);
                System.out.println("\nsearch.metadata-Cache:");
                System.out.println("Hit-Ratio : " + metaDataRatio);
                System.out.println("Hits : " + metaDataHit);
                System.out.println("Miss : " + metaDataMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.metadata-Cache");
            }
            CacheRegionStatistics versionStatistics = null;
            try {
                versionStatistics = statistics.getDomainDataRegionStatistics("search.version");
                long versionHit = versionStatistics.getHitCount();
                long versionMiss = versionStatistics.getMissCount();
                double versionRatio = (double)versionHit / (double)(versionHit + versionMiss);
                System.out.println("\nsearch.version-Cache:");
                System.out.println("Hit-Ratio : " + versionRatio);
                System.out.println("Hits : " + versionHit);
                System.out.println("Miss : " + versionMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.version-Cache");
            }
            CacheRegionStatistics entityStatistics = null;
            try {
                entityStatistics = statistics.getDomainDataRegionStatistics("search.entity");
                long entityHit = entityStatistics.getHitCount();
                long entityMiss = entityStatistics.getMissCount();
                double entityRatio = (double)entityHit / (double)(entityHit + entityMiss);
                System.out.println("\nsearch.entity-Cache:");
                System.out.println("Hit-Ratio : " + entityRatio);
                System.out.println("Hits : " + entityHit);
                System.out.println("Miss : " + entityMiss);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("didnt use search.entity-Cache");
            }
            System.out.println("\n**********************************\n");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("couldnt found statistic");
        }
    }

    public static void getStatistic(Statistics statistics) {
        try {
            if (!statistics.isStatisticsEnabled()) {
                System.out.println("WARN: statistics disabled");
            }
            System.out.println("\n******** Permission-Statistic ********");
            CacheRegionStatistics rootStatistics = null;
            try {
                rootStatistics = statistics.getDomainDataRegionStatistics("query.root");
                long rootHit = rootStatistics.getHitCount();
                long rootMiss = rootStatistics.getMissCount();
                double rootRatio = (double)rootHit / (double)(rootHit + rootMiss);
                System.out.println("\nquery.root-Cache:");
                System.out.println("Hit-Ratio : " + rootRatio);
                System.out.println("Hits : " + rootHit);
                System.out.println("Miss : " + rootMiss);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("didnt use query.root-Cache");
            }
            CacheRegionStatistics permissionStatistics = null;
            try {
                permissionStatistics = statistics.getDomainDataRegionStatistics("query.permission");
                long permissionHit = permissionStatistics.getHitCount();
                long permissionMiss = permissionStatistics.getMissCount();
                double permissionRatio = (double)permissionHit / (double)(permissionHit + permissionMiss);
                System.out.println("\nquery.permission-Cache:");
                System.out.println("Hit-Ratio : " + permissionRatio);
                System.out.println("Hits : " + permissionHit);
                System.out.println("Miss : " + permissionMiss);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("didnt use query.permission-Cache");
            }
            CacheRegionStatistics principalStatistics = null;
            try {
                principalStatistics = statistics.getDomainDataRegionStatistics("query.principal");
                long principalHit = principalStatistics.getHitCount();
                long principalMiss = principalStatistics.getMissCount();
                double principalRatio = (double)principalHit / (double)(principalHit + principalMiss);
                System.out.println("\nquery.principal-Cache:");
                System.out.println("Hit-Ratio : " + principalRatio);
                System.out.println("Hits : " + principalHit);
                System.out.println("Miss : " + principalMiss);
                System.out.println("\n**************************************");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("didnt use query.principal-Cache");
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("couldnt found statistic");
        }
    }

    public static boolean openURL(String url) {
        block12: {
            InetSocketAddress proxy = EdalConfiguration.guessProxySettings();
            if (proxy != null) {
                System.setProperty("http.proxyHost", proxy.getHostName());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getPort()));
                System.setProperty("https.proxyHost", proxy.getHostName());
                System.setProperty("https.proxyPort", String.valueOf(proxy.getPort()));
            }
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    if (url.startsWith("mailto")) {
                        Desktop.getDesktop().mail(URI.create(url));
                    } else {
                        Desktop.getDesktop().browse(URI.create(url));
                    }
                    return true;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "unable to open Browser :", String.valueOf(e.getMessage()) + "\n please enter the URL manually into your browser: '" + url + "'", 0);
                    return false;
                }
            }
            String os = System.getProperty("os.name").toLowerCase();
            Runtime rt = Runtime.getRuntime();
            try {
                if (os.indexOf("win") >= 0) {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break block12;
                }
                if (os.indexOf("mac") >= 0) {
                    rt.exec("open " + url);
                    break block12;
                }
                if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                    String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                    StringBuffer cmd = new StringBuffer();
                    int i = 0;
                    while (i < browsers.length) {
                        cmd.append(String.valueOf(i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                        ++i;
                    }
                    rt.exec(new String[]{"sh", "-c", cmd.toString()});
                    break block12;
                }
                JOptionPane.showMessageDialog(null, "unable to find OS versino to open Browser ", "\n Please enter the URL manually into your browser: '" + url + "'", 0);
                return false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "unable to open Browser :", String.valueOf(e.getMessage()) + "\n please enter the URL manually into your browser: '" + url + "'", 0);
                return false;
            }
        }
        return true;
    }
}

