/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.sample;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SimpleSwingBrowserFrame
extends JFrame {
    private static final long serialVersionUID = -1020717132929889432L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnGo = new JButton("Go");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private boolean loadingFinished = false;

    static {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Class.forName("javafx.application.Platform");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please use an Oracle_JRE to run this module", "No Oracle_JRE found", 0);
            System.exit(-1);
        }
    }

    public SimpleSwingBrowserFrame(boolean showAddressLine) {
        this.initComponents(showAddressLine);
    }

    private void initComponents(boolean showAddressLine) {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSwingBrowserFrame.this.loadURL(SimpleSwingBrowserFrame.this.txtURL.getText());
            }
        };
        this.btnGo.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        topBar.add((Component)this.btnGo, "East");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        if (showAddressLine) {
            this.panel.add((Component)topBar, "North");
        }
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(1024, 600));
        this.pack();
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                SimpleSwingBrowserFrame.this.engine = view.getEngine();
                SimpleSwingBrowserFrame.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserFrame.this.setTitle(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowserFrame.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserFrame.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                SimpleSwingBrowserFrame.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserFrame.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowserFrame.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowserFrame.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                SimpleSwingBrowserFrame.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (SimpleSwingBrowserFrame.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(SimpleSwingBrowserFrame.this.panel, value != null ? String.valueOf(SimpleSwingBrowserFrame.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(SimpleSwingBrowserFrame.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                SimpleSwingBrowserFrame.this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.SUCCEEDED) {
                            SimpleSwingBrowserFrame.this.loadingFinished = true;
                        }
                    }
                });
                SimpleSwingBrowserFrame.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = SimpleSwingBrowserFrame.toURL(url);
                if (tmp == null) {
                    tmp = SimpleSwingBrowserFrame.toURL("http://" + url);
                }
                SimpleSwingBrowserFrame.this.engine.load(tmp);
            }
        });
    }

    public boolean isLoadingFinished() {
        return this.loadingFinished;
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void main(String[] args) {
        InetSocketAddress i = EdalConfiguration.guessProxySettings();
        System.setProperty("http.proxyHost", i.getHostName());
        System.setProperty("http.proxyPort", String.valueOf(i.getPort()));
        System.setProperty("https.proxyHost", i.getHostName());
        System.setProperty("https.proxyPort", String.valueOf(i.getPort()));
        CountDownLatch latch = new CountDownLatch(1);
        final SimpleSwingBrowserFrame browser = new SimpleSwingBrowserFrame(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                browser.setVisible(true);
                browser.loadURL("http://oracle.com");
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(browser.isLoadingFinished());
    }
}

