/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.enforcer.rules;

import de.is24.maven.enforcer.rules.Repository;
import de.is24.maven.enforcer.rules.Types;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

final class ClassDependencyResolvingVisitor
extends ClassVisitor {
    private final Repository repository;
    private final Log logger;
    private final AnnotationVisitor annotationVisitor = new ClassDependencyAnnotationVisitor();
    private final FieldVisitor fieldVisitor = new ClassDependencyFieldVisitor();
    private final MethodVisitor methodVisitor = new ClassDependencyMethodVisitor();
    private final SignatureVisitor signatureVisitor = new ClassDependencySignatureVisitor();

    ClassDependencyResolvingVisitor(Repository repository, Log logger) {
        super(327680);
        this.repository = repository;
        this.logger = logger;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String className = Types.readInternalTypeName(name);
        this.logger.debug((CharSequence)("Add new type '" + className + "'."));
        this.repository.addType(className);
        if (superName != null) {
            String superTypeName = Types.readInternalTypeName(superName);
            this.addDependency("super type", superTypeName);
        }
        if (interfaces != null) {
            for (String iface : interfaces) {
                String interfaceType = Types.readInternalTypeName(iface);
                this.addDependency("interface type", interfaceType);
            }
        }
        this.processSignature(signature);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String fieldType = Types.readTypeDescription(desc);
        this.addDependency("field type", fieldType);
        if (value != null) {
            String fieldValueType = Types.readValueType(value);
            this.addDependency("field value type", fieldValueType);
        }
        this.processSignature(signature);
        return this.fieldVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.delegateToAnnotationVisitor(desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String innerClassName = Types.readInternalTypeName(name);
        this.addDependency("inner class", innerClassName);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type[] argumentTypes;
        for (Type argumentType : argumentTypes = Type.getArgumentTypes((String)desc)) {
            String parameterTypeName = Types.readType(argumentType);
            this.addDependency("annotation's method parameter type", parameterTypeName);
        }
        Type returnType = Type.getReturnType((String)desc);
        String returnTypeName = Types.readType(returnType);
        this.addDependency("annotation's method return type", returnTypeName);
        if (exceptions != null) {
            for (String exception : exceptions) {
                String exceptionName = Types.readInternalTypeName(exception);
                this.addDependency("exception type", exceptionName);
            }
        }
        this.processSignature(signature);
        return this.methodVisitor;
    }

    private AnnotationVisitor delegateToAnnotationVisitor(String desc) {
        String annotationType = Types.readTypeDescription(desc);
        this.addDependency("annotation", annotationType);
        return this.annotationVisitor;
    }

    private void addDependency(String typeDescription, String typeName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Add " + typeDescription + " '" + typeName + "' as dependency."));
        }
        this.repository.addDependency(typeName);
    }

    private void processSignature(String signature) {
        if (signature != null) {
            SignatureReader signatureReader = new SignatureReader(signature);
            signatureReader.accept(this.signatureVisitor);
        }
    }

    private final class ClassDependencyMethodVisitor
    extends MethodVisitor {
        private ClassDependencyMethodVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return ClassDependencyResolvingVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return ClassDependencyResolvingVisitor.this.delegateToAnnotationVisitor(desc);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return ClassDependencyResolvingVisitor.this.delegateToAnnotationVisitor(desc);
        }

        public void visitTypeInsn(int opcode, String type) {
            String typeName = Types.readInternalTypeName(type);
            ClassDependencyResolvingVisitor.this.addDependency("Type instruction type", typeName);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String fieldType = Types.readTypeDescription(desc);
            ClassDependencyResolvingVisitor.this.addDependency("field instruction type", fieldType);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Type[] argumentTypes;
            String ownerType = Types.readInternalTypeName(owner);
            ClassDependencyResolvingVisitor.this.addDependency("method owner", ownerType);
            for (Type argumentType : argumentTypes = Type.getArgumentTypes((String)desc)) {
                String parameterTypeName = Types.readType(argumentType);
                ClassDependencyResolvingVisitor.this.addDependency("method parameter type", parameterTypeName);
            }
            Type returnType = Type.getReturnType((String)desc);
            String returnTypeName = Types.readType(returnType);
            ClassDependencyResolvingVisitor.this.addDependency("method return type", returnTypeName);
        }

        public void visitLdcInsn(Object cst) {
            String constantTypeName = Types.readValueType(cst);
            ClassDependencyResolvingVisitor.this.addDependency("constant's type", constantTypeName);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            String arrayType = Types.readTypeDescription(desc);
            ClassDependencyResolvingVisitor.this.addDependency("array's type", arrayType);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                String exceptionType = Types.readInternalTypeName(type);
                ClassDependencyResolvingVisitor.this.addDependency("exception type", exceptionType);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            String localVariableType = Types.readTypeDescription(desc);
            ClassDependencyResolvingVisitor.this.addDependency("local variable", localVariableType);
            ClassDependencyResolvingVisitor.this.processSignature(signature);
        }
    }

    private final class ClassDependencyFieldVisitor
    extends FieldVisitor {
        private ClassDependencyFieldVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return ClassDependencyResolvingVisitor.this.delegateToAnnotationVisitor(desc);
        }
    }

    private final class ClassDependencyAnnotationVisitor
    extends AnnotationVisitor {
        private ClassDependencyAnnotationVisitor() {
            super(327680);
        }

        public void visit(String name, Object value) {
            String valueType = Types.readValueType(value);
            ClassDependencyResolvingVisitor.this.addDependency("annotation's value type", valueType);
        }

        public void visitEnum(String name, String desc, String value) {
            String enumType = Types.readTypeDescription(desc);
            ClassDependencyResolvingVisitor.this.addDependency("annotation's enum type", enumType);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String annotationType = Types.readTypeDescription(desc);
            ClassDependencyResolvingVisitor.this.addDependency("annotation's annotation type", annotationType);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private final class ClassDependencySignatureVisitor
    extends SignatureVisitor {
        private ClassDependencySignatureVisitor() {
            super(327680);
        }

        public void visitClassType(String name) {
            String classType = Types.readInternalTypeName(name);
            ClassDependencyResolvingVisitor.this.addDependency("class type", classType);
        }
    }
}

