/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.enforcer.rules;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

final class ClassFilter {
    private static final String JAVA_TYPES_REGEX = "[0-9\\$]+|(boolean)|(byte)|(char)|(short)|(int)|(long)|(float)|(double)|(void)|(java\\.[\\w\\.\\$]*)";
    private static final String JAVA_HOME_PATH = "file:" + System.getProperty("java.home");
    private static final Pattern JAVA_RUNTIME_PACKAGES = Pattern.compile("^(javax|com\\.sun|org|sun|jdk)\\..+");
    private final Map<String, Boolean> alreadyProcessedJavaTypes = new HashMap<String, Boolean>();
    private final Pattern ignoredClassesPattern;
    private final boolean suppressTypesFromJavaRuntime;
    private final Log logger;

    ClassFilter(Log logger, boolean suppressTypesFromJavaRuntime, String ... regexIgnoredClasses) {
        this.logger = logger;
        this.suppressTypesFromJavaRuntime = suppressTypesFromJavaRuntime;
        if (regexIgnoredClasses == null || regexIgnoredClasses.length == 0) {
            this.ignoredClassesPattern = Pattern.compile(JAVA_TYPES_REGEX);
        } else {
            StringBuilder regexBuilder = new StringBuilder(JAVA_TYPES_REGEX);
            for (String regex : regexIgnoredClasses) {
                if (!StringUtils.isNotEmpty((String)regex)) continue;
                regexBuilder.append("|(").append(regex).append(")");
            }
            String regex = regexBuilder.toString();
            logger.debug((CharSequence)("Use type suppression pattern '" + regex + "'."));
            this.ignoredClassesPattern = Pattern.compile(regex);
        }
    }

    private boolean typeFromJavaRuntime(String type) {
        if (JAVA_RUNTIME_PACKAGES.matcher(type).matches()) {
            String sourcePath;
            Boolean isJdkType = this.alreadyProcessedJavaTypes.get(type);
            if (isJdkType != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)("Type's '" + type + "' existence in current Java runtime has already been checked."));
                }
                return isJdkType;
            }
            String classResource = type.replace('.', '/') + ".class";
            URL it = ClassLoader.getSystemClassLoader().getResource(classResource);
            if (it != null && (sourcePath = it.getFile()).startsWith(JAVA_HOME_PATH)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)("Suppress type '" + type + "', it's in current Java runtime '" + JAVA_HOME_PATH + "'."));
                }
                this.alreadyProcessedJavaTypes.put(type, true);
                return true;
            }
            this.alreadyProcessedJavaTypes.put(type, false);
            return false;
        }
        return false;
    }

    void addFiltered(Collection<String> set, String type) {
        if (this.isConsideredType(type)) {
            set.add(type);
        }
    }

    boolean isConsideredType(String type) {
        if (this.ignoredClassesPattern.matcher(type).matches()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Suppress type '" + type + "'."));
            }
            return false;
        }
        return !this.suppressTypesFromJavaRuntime || !this.typeFromJavaRuntime(type);
    }
}

