/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.collect.Maps;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.IntermediateResult;
import de.is24.deadcode4j.Module;
import de.is24.guava.NonNullFunction;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnalysisContext
extends AnalysisSink {
    @Nonnull
    private final Map<Object, Object> cache = Maps.newHashMap();
    @Nonnull
    private final Module module;
    @Nonnull
    private final Map<Object, IntermediateResult> intermediateResults;

    public AnalysisContext(@Nonnull Module module, @Nonnull Map<Object, IntermediateResult> intermediateResults) {
        this.module = module;
        this.intermediateResults = Maps.newHashMap(intermediateResults);
    }

    @Override
    public String toString() {
        return "AnalysisContext for [" + this.module + "]";
    }

    @Nonnull
    public Module getModule() {
        return this.module;
    }

    @Nonnull
    public Map<Object, Object> getCache() {
        return this.cache;
    }

    @Nonnull
    public <T> T getOrCreateCacheEntry(Object key, NonNullFunction<AnalysisContext, T> supplier) {
        Object entry = this.getCache().get(key);
        if (entry == null) {
            entry = supplier.apply(this);
            this.getCache().put(key, entry);
        }
        return (T)entry;
    }

    @Nullable
    public IntermediateResult getIntermediateResult(@Nonnull Object key) {
        return this.intermediateResults.get(key);
    }
}

