/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisStage;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisSink {
    @Nonnull
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final Set<String> analyzedClasses = Sets.newHashSet();
    @Nonnull
    private final Map<String, Set<String>> dependencyMap = Maps.newHashMap();
    @Nonnull
    private final EnumSet<AnalysisStage> stagesWithExceptions = EnumSet.noneOf(AnalysisStage.class);

    public String toString() {
        return "AnalysisSink";
    }

    public void addAnalyzedClass(@Nonnull String clazz) {
        this.analyzedClasses.add(clazz);
    }

    public void addDependencies(@Nonnull String depender, @Nonnull Iterable<String> dependees) {
        if (Iterables.size((Iterable)(dependees = Iterables.filter(dependees, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)depender))))) == 0) {
            return;
        }
        Set<String> existingDependees = Utils.getOrAddMappedSet(this.dependencyMap, depender);
        for (String aDependee : dependees) {
            existingDependees.add(aDependee);
        }
        this.logger.debug("Added dependencies from [{}] to {}.", (Object)depender, (Object)dependees);
    }

    public void addDependencies(@Nonnull String depender, String ... dependees) {
        this.addDependencies(depender, Arrays.asList(dependees));
    }

    public void addException(@Nonnull AnalysisStage stage) {
        this.stagesWithExceptions.add(stage);
    }

    @Nonnull
    public AnalyzedCode getAnalyzedCode() {
        return new AnalyzedCode(this.stagesWithExceptions, this.analyzedClasses, this.dependencyMap);
    }
}

