/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.DeadCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;

public class DeadCodeComputer {
    @Nonnull
    public DeadCode computeDeadCode(@Nonnull AnalyzedCode analyzedCode) {
        Collection<String> deadClasses = this.determineDeadClasses(analyzedCode);
        return new DeadCode(analyzedCode.getStagesWithExceptions(), analyzedCode.getAnalyzedClasses(), deadClasses);
    }

    @Nonnull
    private Collection<String> determineDeadClasses(@Nonnull AnalyzedCode analyzedCode) {
        HashSet classesInUse = Sets.newHashSet();
        for (Iterable iterable : analyzedCode.getCodeDependencies().values()) {
            for (String clazz : iterable) {
                classesInUse.add(clazz);
            }
        }
        ArrayList deadClasses = Lists.newArrayList(analyzedCode.getAnalyzedClasses());
        deadClasses.removeAll(classesInUse);
        return deadClasses;
    }
}

