/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalysisStage;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.Analyzer;
import de.is24.deadcode4j.DeadCode;
import de.is24.deadcode4j.DeadCodeComputer;
import de.is24.deadcode4j.IntermediateResults;
import de.is24.deadcode4j.Module;
import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.DirectoryWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadCodeFinder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final DeadCodeComputer deadCodeComputer;
    @Nonnull
    private final Iterable<? extends Analyzer> analyzers;

    public DeadCodeFinder(@Nonnull DeadCodeComputer deadCodeComputer, @Nonnull Set<? extends Analyzer> analyzers) {
        this.deadCodeComputer = deadCodeComputer;
        this.analyzers = Lists.newArrayList(analyzers);
    }

    @Nonnull
    public DeadCode findDeadCode(@Nonnull Iterable<Module> modules) {
        AnalyzedCode analyzedCode = this.analyzeCode(modules);
        return this.computeDeadCode(analyzedCode);
    }

    @Nonnull
    private AnalyzedCode analyzeCode(@Nonnull Iterable<Module> modules) {
        ArrayList analyzedCode = Lists.newArrayList();
        IntermediateResults intermediateResults = new IntermediateResults();
        for (Module module : Module.sort(modules)) {
            AnalysisContext analysisContext = new AnalysisContext(module, intermediateResults.calculateIntermediateResultsFor(module));
            for (Repository repository : module.getAllRepositories()) {
                this.analyzeRepository(analysisContext, repository);
            }
            this.logger.debug("Finishing analysis of [{}]...", (Object)analysisContext);
            for (Analyzer analyzer : this.analyzers) {
                analyzer.finishAnalysis(analysisContext);
            }
            this.logger.debug("Finished analysis of [{}].", (Object)analysisContext);
            intermediateResults.add(analysisContext);
            analyzedCode.add(analysisContext.getAnalyzedCode());
        }
        this.logger.debug("Finishing analysis of whole project...");
        AnalyzedCode combinedAnalysis = this.merge(analyzedCode);
        for (Analyzer analyzer : this.analyzers) {
            AnalysisSink analysisSink = new AnalysisSink();
            analyzer.finishAnalysis(analysisSink, combinedAnalysis);
            combinedAnalysis = this.merge(combinedAnalysis, analysisSink);
        }
        this.logger.debug("Finished analysis of project.");
        return combinedAnalysis;
    }

    @Nonnull
    private DeadCode computeDeadCode(@Nonnull AnalyzedCode analyzedCode) {
        return this.deadCodeComputer.computeDeadCode(analyzedCode);
    }

    private void analyzeRepository(@Nonnull AnalysisContext analysisContext, @Nonnull Repository repository) {
        RepositoryAnalyzer repositoryAnalyzer = new RepositoryAnalyzer(analysisContext, repository, this.analyzers);
        try {
            repositoryAnalyzer.analyze();
        }
        catch (IOException e) {
            throw new RuntimeException("This was unexpected; failed to parse files of " + repository + "!", e);
        }
    }

    @Nonnull
    private AnalyzedCode merge(@Nonnull List<AnalyzedCode> analyzedCode) {
        EnumSet<AnalysisStage> stagesWithExceptions = EnumSet.noneOf(AnalysisStage.class);
        HashSet analyzedClasses = Sets.newHashSet();
        HashMap dependencies = Maps.newHashMap();
        for (AnalyzedCode code : analyzedCode) {
            stagesWithExceptions.addAll(code.getStagesWithExceptions());
            analyzedClasses.addAll(code.getAnalyzedClasses());
            for (Map.Entry<String, Set<String>> dependencyEntry : code.getCodeDependencies().entrySet()) {
                Set knownDependencies = Utils.getOrAddMappedSet(dependencies, dependencyEntry.getKey());
                knownDependencies.addAll((Collection)dependencyEntry.getValue());
            }
        }
        return new AnalyzedCode(stagesWithExceptions, analyzedClasses, dependencies);
    }

    @Nonnull
    private AnalyzedCode merge(@Nonnull AnalyzedCode analyzedCode, @Nonnull AnalysisSink analysisSink) {
        AnalyzedCode analysisToAdd = analysisSink.getAnalyzedCode();
        if (analysisToAdd.getStagesWithExceptions().isEmpty() && analysisToAdd.getAnalyzedClasses().isEmpty() && analysisToAdd.getCodeDependencies().isEmpty()) {
            return analyzedCode;
        }
        return this.merge(Arrays.asList(analyzedCode, analysisToAdd));
    }

    private static class RepositoryAnalyzer
    extends DirectoryWalker<Void> {
        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private final AnalysisContext analysisContext;
        private final Repository repository;
        private final Iterable<? extends Analyzer> analyzers;

        public RepositoryAnalyzer(@Nonnull AnalysisContext analysisContext, @Nonnull Repository repository, @Nonnull Iterable<? extends Analyzer> analyzers) {
            super(repository.getFileFilter(), -1);
            this.repository = repository;
            this.analysisContext = analysisContext;
            this.analyzers = analyzers;
        }

        public void analyze() throws IOException {
            this.logger.debug("Starting analysis of [{}]...", (Object)this.repository);
            super.walk(this.repository.getDirectory(), null);
        }

        protected void handleFile(File file, int depth, Collection results) {
            this.logger.debug("Analyzing file [{}]...", (Object)file);
            for (Analyzer analyzer : this.analyzers) {
                try {
                    analyzer.doAnalysis(this.analysisContext, file);
                }
                catch (RuntimeException rE) {
                    this.logger.warn("Analyzer [{}] failed to analyze file [{}]!", new Object[]{analyzer, file, rE});
                    this.analysisContext.addException(AnalysisStage.FILE_ANALYSIS);
                }
            }
        }

        protected void handleEnd(Collection<Void> results) {
            this.logger.debug("Analysis of [{}] is done.", (Object)this.repository);
        }
    }
}

