/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.IntermediateResult;
import de.is24.deadcode4j.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntermediateResults {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final Map<Module, Map<Object, IntermediateResult>> intermediateResults = Maps.newHashMap();

    @Nonnull
    public static <E> IntermediateResultSet<E> resultSetFor(@Nonnull Collection<E> intermediateResults) {
        return new IntermediateResultSet<E>(intermediateResults);
    }

    @Nonnull
    public static <K, V> IntermediateResultMap<K, V> resultMapFor(@Nonnull Map<K, V> intermediateResults) {
        return new IntermediateResultMap<K, V>(intermediateResults);
    }

    @Nullable
    public static <E> IntermediateResultSet<E> resultSetFrom(@Nonnull AnalysisContext analysisContext, Object key) {
        return (IntermediateResultSet)analysisContext.getIntermediateResult(key);
    }

    @Nullable
    public static <K, V> IntermediateResultMap<K, V> resultMapFrom(@Nonnull AnalysisContext analysisContext, Object key) {
        return (IntermediateResultMap)analysisContext.getIntermediateResult(key);
    }

    public void add(@Nonnull AnalysisContext analysisContext) {
        this.intermediateResults.put(analysisContext.getModule(), this.getIntermediateResultsOf(analysisContext));
    }

    @Nonnull
    public Map<Object, IntermediateResult> calculateIntermediateResultsFor(@Nonnull Module module) {
        return this.calculateIntermediateResults(module);
    }

    @Nonnull
    private Map<Object, IntermediateResult> getIntermediateResultsOf(@Nonnull AnalysisContext analysisContext) {
        HashMap intermediateResults = Maps.newHashMap();
        for (Map.Entry<Object, Object> cachedEntry : analysisContext.getCache().entrySet()) {
            Object cachedValue = cachedEntry.getValue();
            if (!IntermediateResult.class.isInstance(cachedValue)) continue;
            this.logger.debug("{} stored [{}].", (Object)analysisContext.getModule(), cachedValue);
            intermediateResults.put(cachedEntry.getKey(), IntermediateResult.class.cast(cachedValue));
        }
        return intermediateResults;
    }

    @Nonnull
    private Map<Object, IntermediateResult> calculateIntermediateResults(@Nonnull Module module) {
        Map<Object, IntermediateResult> results = this.calculateResultsOfParentsFor(module);
        this.mergeWithResultsOf(module, results);
        return results;
    }

    @Nonnull
    private Map<Object, IntermediateResult> calculateResultsOfParentsFor(@Nonnull Module module) {
        HashMap mergedResults = Maps.newHashMap();
        for (Module requiredModule : module.getRequiredModules()) {
            Map<Object, IntermediateResult> results = this.calculateIntermediateResults(requiredModule);
            for (Map.Entry<Object, IntermediateResult> resultEntry : results.entrySet()) {
                Object key = resultEntry.getKey();
                IntermediateResult intermediateResult = resultEntry.getValue();
                IntermediateResult existingResult = (IntermediateResult)mergedResults.get(key);
                mergedResults.put(key, existingResult == null ? intermediateResult : existingResult.mergeSibling(intermediateResult));
            }
        }
        return mergedResults;
    }

    private void mergeWithResultsOf(@Nonnull Module module, @Nonnull Map<Object, IntermediateResult> combinedResults) {
        Map<Object, IntermediateResult> intermediateResultsOfModule = this.intermediateResults.get(module);
        if (intermediateResultsOfModule == null) {
            return;
        }
        for (Map.Entry<Object, IntermediateResult> resultEntry : intermediateResultsOfModule.entrySet()) {
            Object key = resultEntry.getKey();
            IntermediateResult intermediateResult = resultEntry.getValue();
            IntermediateResult parentResult = combinedResults.get(key);
            combinedResults.put(key, parentResult == null ? intermediateResult : intermediateResult.mergeParent(parentResult));
        }
    }

    public static class IntermediateResultMap<K, V>
    implements IntermediateResult {
        @Nonnull
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        @Nonnull
        private final Map<K, V> results;

        public IntermediateResultMap(@Nonnull Map<K, V> results) {
            this.results = Collections.unmodifiableMap(Maps.newHashMap(results));
        }

        @Nonnull
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.results;
        }

        @Override
        @Nonnull
        public IntermediateResult mergeSibling(@Nonnull IntermediateResult sibling) {
            return this.merge(sibling);
        }

        @Override
        @Nonnull
        public IntermediateResult mergeParent(@Nonnull IntermediateResult parent) {
            return this.merge(parent);
        }

        @Nonnull
        public Map<K, V> getResults() {
            return this.results;
        }

        @Nonnull
        private IntermediateResult merge(@Nonnull IntermediateResult result) {
            HashMap mergedResults = Maps.newHashMap(this.getResults());
            for (Map.Entry<K, V> resultEntry : this.getResults(result).entrySet()) {
                K key = resultEntry.getKey();
                V value = resultEntry.getValue();
                Object existingResult = mergedResults.get(key);
                if (existingResult == null) {
                    mergedResults.put(key, value);
                    continue;
                }
                if (Collection.class.isInstance(existingResult)) {
                    ((Collection)Collection.class.cast(existingResult)).addAll((Collection)Collection.class.cast(value));
                    continue;
                }
                if (existingResult.equals(value)) continue;
                this.logger.debug("Intermediate result [{}] refers to [{}] and [{}] defined by different modules, keeping the former.", new Object[]{key, existingResult, value});
            }
            return new IntermediateResultMap<K, V>(mergedResults);
        }

        @Nonnull
        private Map<K, V> getResults(IntermediateResult result) {
            return ((IntermediateResultMap)IntermediateResultMap.class.cast(result)).getResults();
        }
    }

    public static class IntermediateResultSet<E>
    implements IntermediateResult {
        @Nonnull
        private final Set<E> results;

        public IntermediateResultSet(@Nonnull Collection<E> results) {
            this.results = Collections.unmodifiableSet(Sets.newHashSet(results));
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.results;
        }

        @Override
        @Nonnull
        public IntermediateResult mergeSibling(@Nonnull IntermediateResult sibling) {
            return this.merge(sibling);
        }

        @Override
        @Nonnull
        public IntermediateResult mergeParent(@Nonnull IntermediateResult parent) {
            return this.merge(parent);
        }

        @Nonnull
        public Set<E> getResults() {
            return this.results;
        }

        @Nonnull
        private IntermediateResult merge(@Nonnull IntermediateResult result) {
            HashSet mergedResults = Sets.newHashSet(this.results);
            mergedResults.addAll(this.getResults(result));
            return new IntermediateResultSet<E>(mergedResults);
        }

        @Nonnull
        private Set<E> getResults(@Nonnull IntermediateResult result) {
            return ((IntermediateResultSet)IntermediateResultSet.class.cast(result)).getResults();
        }
    }
}

