/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import de.is24.deadcode4j.Repository;
import de.is24.deadcode4j.Resource;
import de.is24.deadcode4j.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Module {
    @Nonnull
    private final String moduleId;
    @Nullable
    private final String encoding;
    @Nonnull
    private final Collection<Resource> dependencies;
    @Nullable
    private final Repository outputRepository;
    @Nonnull
    private final List<Repository> allRepositories;

    public Module(@Nonnull String moduleId, @Nullable String encoding, @Nonnull Collection<Resource> dependencies, @Nullable Repository outputRepository, @Nonnull Iterable<Repository> repositories) {
        this.moduleId = moduleId;
        this.encoding = encoding;
        this.dependencies = dependencies;
        this.outputRepository = outputRepository;
        this.allRepositories = Lists.newArrayList();
        Utils.addIfNonNull(this.allRepositories, outputRepository);
        Iterables.addAll(this.allRepositories, repositories);
    }

    @Nonnull
    public static Iterable<Module> sort(@Nonnull Iterable<Module> modules) {
        ArrayList unsortedModules = Lists.newArrayList(modules);
        ArrayList sortedModules = Lists.newArrayListWithCapacity((int)unsortedModules.size());
        while (!unsortedModules.isEmpty()) {
            List<Module> modulesToAdd = Lists.newArrayList();
            for (Module module : unsortedModules) {
                if (!sortedModules.containsAll(module.getRequiredModules())) continue;
                modulesToAdd.add(module);
            }
            if (modulesToAdd.isEmpty()) {
                Logger logger = LoggerFactory.getLogger(Module.class);
                logger.error("Could not resolve dependencies for all modules! Those modules are affected:");
                for (Module unsortedModule : unsortedModules) {
                    ArrayList unresolvedModules = Lists.newArrayList(unsortedModule.getRequiredModules());
                    unresolvedModules.removeAll(sortedModules);
                    logger.error("  {} requires {}", (Object)unsortedModule, (Object)unresolvedModules);
                }
                throw new RuntimeException("Could not build dependency graph!");
            }
            modulesToAdd = Ordering.natural().onResultOf(Module.toModuleId()).sortedCopy((Iterable)modulesToAdd);
            sortedModules.addAll(modulesToAdd);
            unsortedModules.removeAll(modulesToAdd);
        }
        return sortedModules;
    }

    @Nonnull
    private static Function<Module, String> toModuleId() {
        return new Function<Module, String>(){

            @Nullable
            public String apply(@Nullable Module input) {
                return input == null ? null : input.getModuleId();
            }
        };
    }

    public boolean equals(Object obj) {
        return this == obj || Module.class.isInstance(obj) && this.moduleId.equals(((Module)Module.class.cast((Object)obj)).moduleId);
    }

    public int hashCode() {
        return this.moduleId.hashCode();
    }

    public String toString() {
        return "Module [" + this.moduleId + "]";
    }

    @Nonnull
    public String getModuleId() {
        return this.moduleId;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @Nonnull
    public Iterable<File> getClassPath() {
        ArrayList classPath = Lists.newArrayListWithCapacity((int)this.dependencies.size());
        for (Resource dependency : this.dependencies) {
            Optional<File> classPathEntry = dependency.getClassPathEntry();
            if (!classPathEntry.isPresent()) continue;
            classPath.add(classPathEntry.get());
        }
        return classPath;
    }

    @Nonnull
    public Collection<Module> getRequiredModules() {
        ArrayList requiredModules = Lists.newArrayList();
        for (Resource dependency : this.dependencies) {
            Optional<Module> moduleEntry = dependency.getReferencedModule();
            if (!moduleEntry.isPresent()) continue;
            requiredModules.add(moduleEntry.get());
        }
        return requiredModules;
    }

    @Nullable
    public Repository getOutputRepository() {
        return this.outputRepository;
    }

    @Nonnull
    public Iterable<Repository> getAllRepositories() {
        return this.allRepositories;
    }
}

