/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.base.Optional;
import de.is24.deadcode4j.Module;
import de.is24.deadcode4j.Repository;
import java.io.File;

public abstract class Resource {
    public static Resource of(final File file) {
        return new Resource(){

            @Override
            public Optional<File> getClassPathEntry() {
                return Optional.of((Object)file);
            }

            @Override
            public Optional<Module> getReferencedModule() {
                return Optional.absent();
            }
        };
    }

    public static Resource of(final Module module) {
        return new Resource(){

            @Override
            public Optional<File> getClassPathEntry() {
                Repository repository = module.getOutputRepository();
                return repository != null ? Optional.of((Object)repository.getDirectory()) : Optional.absent();
            }

            @Override
            public Optional<Module> getReferencedModule() {
                return Optional.of((Object)module);
            }
        };
    }

    public abstract Optional<File> getClassPathEntry();

    public abstract Optional<Module> getReferencedModule();
}

