/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public final class Utils {
    private Utils() {
    }

    @Nonnull
    public static String getKeyFor(@Nonnull Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    @Nonnull
    public static String getVersionedKeyFor(@Nonnull Artifact artifact) {
        return Utils.getKeyFor(artifact) + ":" + artifact.getVersion();
    }

    @Nonnull
    public static String getKeyFor(@Nonnull MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId();
    }

    @Nonnull
    public static Function<MavenProject, String> toKey() {
        return new Function<MavenProject, String>(){

            public String apply(@Nullable MavenProject input) {
                return input == null ? null : Utils.getKeyFor(input);
            }
        };
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <E> boolean addIfNonNull(@Nonnull Collection<E> collection, @Nullable E element) {
        return element != null && collection.add(element);
    }

    public static <K, V> V getValueOrDefault(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value != null ? value : defaultValue;
    }

    public static <K, V> Set<V> getOrAddMappedSet(Map<K, Set<V>> map, K key) {
        HashSet values = map.get(key);
        if (values == null) {
            values = Sets.newHashSet();
            map.put(key, values);
        }
        return values;
    }

    @Nonnull
    public static <E> FluentIterable<E> emptyIfNull(@Nullable Iterable<E> iterable) {
        return FluentIterable.from(iterable == null ? Collections.emptyList() : iterable);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
}

