/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import de.is24.deadcode4j.analyzer.javassist.ClassPathFilter;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import de.is24.guava.NonNullFunction;
import de.is24.javassist.CtClasses;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.annotation.Annotation;
import javax.annotation.Nonnull;

public abstract class AnnotationsAnalyzer
extends ByteCodeAnalyzer {
    private static final Set<String> DEAD_ENDS = Sets.newHashSet((Object[])new String[]{"java.lang.annotation.Documented", "java.lang.annotation.Inherited", "java.lang.annotation.Retention", "java.lang.annotation.Target"});
    private final String dependerId;
    private final NonNullFunction<AnalysisContext, Set<String>> supplyAnnotationsFoundInClassPath;
    private final NonNullFunction<AnalysisContext, List<String>> supplyAnnotationsMarkedAsInherited = new NonNullFunction<AnalysisContext, List<String>>(){

        @Override
        @Nonnull
        public List<String> apply(@Nonnull AnalysisContext analysisContext) {
            ArrayList inheritedAnnotations = Lists.newArrayList();
            ClassPool classPool = ClassPoolAccessor.classPoolAccessorFor(analysisContext).getClassPool();
            for (String annotation : AnnotationsAnalyzer.this.getAnnotationsFoundInClassPath(analysisContext)) {
                CtClass annotationClazz = classPool.getOrNull(annotation);
                if (annotationClazz == null) {
                    AnnotationsAnalyzer.this.logger.debug("Annotation [{}] cannot be found on the class path; skipping detection", (Object)annotation);
                    continue;
                }
                try {
                    if (annotationClazz.getAnnotation(Inherited.class) == null) continue;
                    inheritedAnnotations.add(annotation);
                }
                catch (ClassNotFoundException e) {
                    AnnotationsAnalyzer.this.logger.debug("@Inherited is not available; this is quite disturbing.");
                }
            }
            AnnotationsAnalyzer.this.logger.debug("Found those inheritable annotations: {}", (Object)inheritedAnnotations);
            return inheritedAnnotations;
        }
    };

    private AnnotationsAnalyzer(@Nonnull String dependerId, @Nonnull Set<String> annotations) {
        Preconditions.checkArgument((!annotations.isEmpty() ? 1 : 0) != 0, (Object)"annotations cannot by empty!");
        this.dependerId = dependerId;
        this.supplyAnnotationsFoundInClassPath = new ClassPathFilter(annotations);
    }

    protected AnnotationsAnalyzer(@Nonnull String dependerId, @Nonnull Iterable<String> annotations) {
        this(dependerId, Sets.newHashSet(annotations));
    }

    protected AnnotationsAnalyzer(@Nonnull String dependerId, String ... annotations) {
        this(dependerId, Sets.newHashSet((Object[])annotations));
    }

    @Override
    protected final void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        Set<String> availableAnnotations = this.getAnnotationsFoundInClassPath(analysisContext);
        if (availableAnnotations.isEmpty()) {
            return;
        }
        String className = clazz.getName();
        analysisContext.addAnalyzedClass(className);
        HashSet allAnnotations = Sets.newHashSet();
        this.addAnnotations(clazz, allAnnotations);
        allAnnotations.addAll(this.getInheritedAnnotations(analysisContext, clazz));
        if (!Collections.disjoint(availableAnnotations, allAnnotations)) {
            analysisContext.addDependencies(this.dependerId, className);
        }
    }

    private void addAnnotations(@Nonnull CtClass clazz, Set<String> knownAnnotations) {
        for (Annotation annotation : AnnotationsAnalyzer.getAnnotations(clazz, ElementType.PACKAGE, ElementType.TYPE)) {
            CtClass annotationClazz;
            String annotationClassName = annotation.getTypeName();
            if (!knownAnnotations.add(annotationClassName) || DEAD_ENDS.contains(annotationClassName) || (annotationClazz = CtClasses.getCtClass(clazz.getClassPool(), annotationClassName)) == null) continue;
            this.addAnnotations(annotationClazz, knownAnnotations);
        }
    }

    @Nonnull
    private Set<String> getInheritedAnnotations(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        List<String> annotationsMarkedAsInherited = this.getAnnotationsMarkedAsInherited(analysisContext);
        if (annotationsMarkedAsInherited.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet inheritedAnnotations = Sets.newHashSet();
        CtClass loopClass = CtClasses.getSuperclassOf(clazz);
        while (loopClass != null && !CtClasses.isJavaLangObject(loopClass)) {
            for (Annotation annotation : AnnotationsAnalyzer.getAnnotations(loopClass, ElementType.PACKAGE, ElementType.TYPE)) {
                inheritedAnnotations.add(annotation.getTypeName());
            }
            loopClass = CtClasses.getSuperclassOf(loopClass);
        }
        return inheritedAnnotations;
    }

    @Nonnull
    protected final Set<String> getAnnotationsFoundInClassPath(@Nonnull AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(this.getClass().getName() + "|knownAnnotations", this.supplyAnnotationsFoundInClassPath);
    }

    @Nonnull
    private List<String> getAnnotationsMarkedAsInherited(@Nonnull AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(this.getClass().getName() + "|inheritableAnnotations", this.supplyAnnotationsMarkedAsInherited);
    }
}

