/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.AnalyzerAdapter;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import de.is24.guava.NonNullFunction;
import de.is24.guava.NonNullFunctions;
import de.is24.guava.SequentialLoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public abstract class ByteCodeAnalyzer
extends AnalyzerAdapter {
    private static final NonNullFunction<AnalysisContext, LoadingCache<File, Optional<CtClass>>> SUPPLIER = new NonNullFunction<AnalysisContext, LoadingCache<File, Optional<CtClass>>>(){

        @Override
        @Nonnull
        public LoadingCache<File, Optional<CtClass>> apply(final @Nonnull AnalysisContext analysisContext) {
            return SequentialLoadingCache.createSingleValueCache(NonNullFunctions.toFunction(new NonNullFunction<File, Optional<CtClass>>(){

                @Override
                @Nonnull
                public Optional<CtClass> apply(@Nonnull File file) {
                    Optional optional;
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(file);
                        optional = Optional.of((Object)ClassPoolAccessor.classPoolAccessorFor(analysisContext).getClassPool().makeClass((InputStream)in));
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException("Could not load class from [" + file + "]!", e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    return optional;
                }
            }));
        }
    };

    @Nonnull
    protected static Iterable<Annotation> getAnnotations(@Nonnull CtClass clazz, ElementType ... elementTypes) {
        List<ElementType> types = Arrays.asList(elementTypes);
        ArrayList attributes = Lists.newArrayList();
        if (clazz.getName().endsWith("package-info") && types.contains((Object)ElementType.PACKAGE) || !clazz.getName().endsWith("package-info") && types.contains((Object)ElementType.TYPE)) {
            attributes.addAll(clazz.getClassFile2().getAttributes());
        }
        if (types.contains((Object)ElementType.METHOD)) {
            for (CtMethod ctMethod : clazz.getDeclaredMethods()) {
                attributes.addAll(ctMethod.getMethodInfo2().getAttributes());
            }
        }
        if (types.contains((Object)ElementType.FIELD)) {
            for (CtMethod ctMethod : clazz.getDeclaredFields()) {
                attributes.addAll(ctMethod.getFieldInfo2().getAttributes());
            }
        }
        ArrayList annotations = Lists.newArrayList();
        for (AttributeInfo attribute : attributes) {
            if (!AnnotationsAttribute.class.isInstance(attribute)) continue;
            Collections.addAll(annotations, ((AnnotationsAttribute)AnnotationsAttribute.class.cast(attribute)).getAnnotations());
        }
        return annotations;
    }

    private static LoadingCache<File, Optional<CtClass>> getClassLoader(AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(ByteCodeAnalyzer.class, SUPPLIER);
    }

    @Override
    public final void doAnalysis(@Nonnull AnalysisContext analysisContext, @Nonnull File file) {
        if (file.getName().endsWith(".class")) {
            CtClass ctClass = (CtClass)((Optional)ByteCodeAnalyzer.getClassLoader(analysisContext).getUnchecked((Object)file)).get();
            this.logger.debug("Analyzing class [{}]...", (Object)ctClass.getName());
            this.analyzeClass(analysisContext, ctClass);
        }
    }

    protected abstract void analyzeClass(@Nonnull AnalysisContext var1, @Nonnull CtClass var2);
}

