/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.analyzer.AnnotationsAnalyzer;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CustomAnnotationsAnalyzer
extends AnnotationsAnalyzer {
    @Nonnull
    private final Set<String> annotationsNotFoundInClassPath;

    public CustomAnnotationsAnalyzer(@Nonnull Iterable<String> customAnnotations) {
        super("_custom-annotations_", customAnnotations);
        this.annotationsNotFoundInClassPath = Sets.newHashSet(customAnnotations);
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        super.finishAnalysis(analysisContext);
        this.annotationsNotFoundInClassPath.removeAll(this.getAnnotationsFoundInClassPath(analysisContext));
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisSink analysisSink, @Nonnull AnalyzedCode analyzedCode) {
        super.finishAnalysis(analysisSink, analyzedCode);
        for (String interfaceName : this.annotationsNotFoundInClassPath) {
            this.logger.warn("Annotation [{}] wasn't ever found in the class path. You should remove the configuration entry.", (Object)interfaceName);
        }
    }
}

