/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.analyzer.InterfacesAnalyzer;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CustomInterfacesAnalyzer
extends InterfacesAnalyzer {
    @Nonnull
    private final Set<String> interfacesNotFoundInClassPath;

    public CustomInterfacesAnalyzer(@Nonnull Iterable<String> customInterfaces) {
        super("_custom-interfaces_", customInterfaces);
        this.interfacesNotFoundInClassPath = Sets.newHashSet(customInterfaces);
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        super.finishAnalysis(analysisContext);
        this.interfacesNotFoundInClassPath.removeAll(this.getInterfacesFoundInClassPath(analysisContext));
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisSink analysisSink, @Nonnull AnalyzedCode analyzedCode) {
        super.finishAnalysis(analysisSink, analyzedCode);
        for (String interfaceName : this.interfacesNotFoundInClassPath) {
            this.logger.warn("Interface [{}] wasn't ever found in the class path. You should remove the configuration entry.", (Object)interfaceName);
        }
    }
}

