/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.analyzer.SuperClassAnalyzer;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CustomSuperClassAnalyzer
extends SuperClassAnalyzer {
    @Nonnull
    private final Set<String> superClassesNotFoundInClassPath;

    public CustomSuperClassAnalyzer(@Nonnull Iterable<String> customSuperClasses) {
        super("_custom-superclass_", customSuperClasses);
        this.superClassesNotFoundInClassPath = Sets.newHashSet(customSuperClasses);
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        super.finishAnalysis(analysisContext);
        this.superClassesNotFoundInClassPath.removeAll(this.getSuperClassesFoundInClassPath(analysisContext));
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisSink analysisSink, @Nonnull AnalyzedCode analyzedCode) {
        super.finishAnalysis(analysisSink, analyzedCode);
        for (String interfaceName : this.superClassesNotFoundInClassPath) {
            this.logger.warn("SuperClass [{}] wasn't ever found in the class path. You should remove the configuration entry.", (Object)interfaceName);
        }
    }
}

