/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Preconditions;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.SimpleXmlAnalyzer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CustomXmlAnalyzer
extends SimpleXmlAnalyzer {
    private static final Pattern XPATH_PATTERN = Pattern.compile("^([^/\\[]+)(?:\\[@([^=]+)='([^']+)'\\])?/(?:@(.*)|text\\(\\))$");
    private static volatile int instanceNumber = 0;
    private boolean dependencyWasFound = false;

    protected CustomXmlAnalyzer(@Nonnull String dependerId, @Nonnull String endOfFileName, @Nullable String rootElement) {
        super(dependerId, endOfFileName, rootElement);
    }

    public CustomXmlAnalyzer(@Nonnull String endOfFileName, @Nullable String rootElement) {
        this("_custom-XML#" + CustomXmlAnalyzer.getNewInstanceNumber() + "_", endOfFileName, rootElement);
    }

    private static int getNewInstanceNumber() {
        return instanceNumber++;
    }

    public void registerXPath(String xPath) throws IllegalArgumentException {
        Matcher matcher = XPATH_PATTERN.matcher(xPath);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Although [" + xPath + "] may be a valid XPath expression, it is not supported!"));
        String elementName = matcher.group(1);
        String attribute = matcher.group(4);
        SimpleXmlAnalyzer.Element element = attribute != null ? this.registerClassAttribute(elementName, attribute) : this.registerClassElement(elementName);
        if (matcher.group(2) != null) {
            element.withAttributeValue(matcher.group(2), matcher.group(3));
        }
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        super.finishAnalysis(analysisContext);
        Set<String> dependencies = analysisContext.getAnalyzedCode().getCodeDependencies().get(this.dependerId);
        if (!Utils.isEmpty(dependencies)) {
            this.dependencyWasFound = true;
        }
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisSink analysisSink, @Nonnull AnalyzedCode analyzedCode) {
        super.finishAnalysis(analysisSink, analyzedCode);
        if (!this.dependencyWasFound) {
            this.logger.warn("The {} didn't find any class to report. You should remove the configuration entry.", (Object)this);
        }
    }
}

