/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.XmlAnalyzer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ExtendedXmlAnalyzer
extends XmlAnalyzer {
    @Nonnull
    protected final String dependerId;
    @Nullable
    private final String rootElement;
    @Nonnull
    private final Collection<XPath> pathsToMatch = new ArrayList<XPath>();

    protected ExtendedXmlAnalyzer(@Nonnull String dependerId, @Nonnull String endOfFileName, @Nullable String rootElement) {
        super(endOfFileName);
        this.dependerId = Utils.checkNotNull(dependerId);
        this.rootElement = rootElement;
    }

    @Override
    public String toString() {
        StringBuilder buffy = new StringBuilder(1024).append(super.toString());
        buffy.append("; registered XPaths are:");
        for (XPath xPath : this.pathsToMatch) {
            buffy.append("\n");
            if (this.rootElement != null) {
                buffy.append("/").append(this.rootElement);
            }
            buffy.append(xPath);
        }
        return buffy.toString();
    }

    @Nonnull
    public final Path anyElementNamed(@Nonnull String name) {
        return new Path(new Element(name));
    }

    protected ExtendedXmlAnalyzer(@Nonnull String dependerId, @Nonnull String endOfFileName) {
        this(dependerId, endOfFileName, null);
    }

    @Override
    @Nonnull
    protected final DefaultHandler createHandlerFor(@Nonnull AnalysisContext analysisContext) {
        return new XmlHandler(analysisContext);
    }

    @Immutable
    protected class Path {
        @Nonnull
        private final List<Element> pathElements;

        Path(Element firstElement) {
            this.pathElements = Collections.singletonList(firstElement);
        }

        private Path(@Nonnull Path original, String elementName) {
            this.pathElements = new ArrayList<Element>(original.pathElements);
            this.pathElements.add(new Element(elementName));
        }

        private Path(@Nonnull Path original, Element lastElementReplacement) {
            this.pathElements = new ArrayList<Element>(original.pathElements);
            this.pathElements.set(this.pathElements.size() - 1, lastElementReplacement);
        }

        public String toString() {
            StringBuilder buffy = new StringBuilder("//");
            for (Element pathElement : this.pathElements) {
                buffy.append(pathElement).append("/");
            }
            buffy.setLength(buffy.length() - 1);
            return buffy.toString();
        }

        @Nonnull
        public Path anyElementNamed(@Nonnull String name) {
            return new Path(this, name);
        }

        @Nonnull
        public Path withAttributeValue(@Nonnull String attributeName, @Nonnull String requiredValue) {
            return new Path(this, ((Element)Iterables.getLast(this.pathElements)).restrictAttribute(attributeName, requiredValue));
        }

        public void registerDependeeExtractor(DependeeExtractor dependeeExtractor) {
            ExtendedXmlAnalyzer.this.pathsToMatch.add(new XPath(this, dependeeExtractor));
        }

        public void registerTextAsClass() {
            this.registerDependeeExtractor(new DependeeExtractor(){

                @Override
                public String toString() {
                    return "[text()]";
                }

                @Override
                @Nonnull
                public Optional<String> extractDependee(@Nonnull Iterable<XmlElement> xmlElements, @Nonnull Optional<String> containedText) {
                    return containedText;
                }
            });
        }

        public void registerAttributeAsClass(final String attributeName) {
            this.registerDependeeExtractor(new DependeeExtractor(){

                @Override
                public String toString() {
                    return "/@" + attributeName;
                }

                @Override
                @Nonnull
                public Optional<String> extractDependee(@Nonnull Iterable<XmlElement> xmlElements, @Nonnull Optional<String> containedText) {
                    return ((XmlElement)Iterables.getLast(xmlElements)).getAttribute(attributeName);
                }
            });
        }

        boolean matches(@Nonnull Iterable<XmlElement> xmlElements) {
            if (this.pathElements.size() != Iterables.size(xmlElements)) {
                return false;
            }
            Iterator<XmlElement> xmlElementIterator = xmlElements.iterator();
            for (Element pathElement : this.pathElements) {
                if (pathElement.matches(xmlElementIterator.next())) continue;
                return false;
            }
            return true;
        }
    }

    private class XmlHandler
    extends DefaultHandler {
        @Nonnull
        private final AnalysisContext analysisContext;
        @Nonnull
        private final Deque<XmlElement> xmlElements = new ArrayDeque<XmlElement>();
        @Nonnull
        private final Deque<StringBuilder> textBuffers = new ArrayDeque<StringBuilder>();
        private boolean firstElement = true;

        public XmlHandler(AnalysisContext analysisContext) {
            this.analysisContext = analysisContext;
        }

        @Override
        public void startElement(String ignoredUri, String localName, String ignoredQName, Attributes attributes) throws XmlAnalyzer.StopParsing {
            if (this.firstElement) {
                if (ExtendedXmlAnalyzer.this.rootElement != null && !ExtendedXmlAnalyzer.this.rootElement.equals(localName)) {
                    throw new XmlAnalyzer.StopParsing();
                }
                this.firstElement = false;
            }
            this.xmlElements.addLast(new XmlElement(localName, attributes));
            this.textBuffers.addLast(new StringBuilder(128));
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.textBuffers.getLast().append(new String(ch, start, length).trim());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            StringBuilder buffer = this.textBuffers.removeLast();
            Optional text = Optional.fromNullable((Object)(buffer.length() > 0 ? buffer.toString() : null));
            for (XPath xPath : ExtendedXmlAnalyzer.this.pathsToMatch) {
                Optional<String> dependee = xPath.matchAndExtract(this.xmlElements, (Optional<String>)text);
                if (!dependee.isPresent()) continue;
                this.analysisContext.addDependencies(ExtendedXmlAnalyzer.this.dependerId, ((String)dependee.get()).trim());
            }
            this.xmlElements.removeLast();
        }
    }

    @Immutable
    private static class Element {
        @Nonnull
        private final String name;
        @Nonnull
        private final Map<String, String> attributeRestrictions;

        Element(@Nonnull String name) {
            Preconditions.checkArgument((name.trim().length() > 0 ? 1 : 0) != 0, (Object)"The Element's [name] must be set!");
            this.name = name;
            this.attributeRestrictions = Collections.emptyMap();
        }

        private Element(@Nonnull Element original, @Nonnull String attribute, @Nonnull String value) {
            this.name = original.name;
            HashMap<String, String> newAttributeRestrictions = new HashMap<String, String>(original.attributeRestrictions);
            newAttributeRestrictions.put(attribute, value);
            this.attributeRestrictions = newAttributeRestrictions;
        }

        public String toString() {
            StringBuilder buffy = new StringBuilder(this.name);
            if (!this.attributeRestrictions.isEmpty()) {
                buffy.append("[");
                for (Map.Entry<String, String> entry : this.attributeRestrictions.entrySet()) {
                    buffy.append("@").append(entry.getKey()).append("='").append(entry.getValue()).append("' and ");
                }
                buffy.setLength(buffy.length() - 5);
                buffy.append("]");
            }
            return buffy.toString();
        }

        @Nonnull
        Element restrictAttribute(@Nonnull String attribute, @Nonnull String value) {
            return new Element(this, attribute, value);
        }

        boolean matches(@Nonnull XmlElement xmlElement) {
            return this.name.equals(xmlElement.name) && this.matchesAttributes(xmlElement);
        }

        private boolean matchesAttributes(@Nonnull XmlElement xmlElement) {
            for (Map.Entry<String, String> attributeRestriction : this.attributeRestrictions.entrySet()) {
                Optional<String> value = xmlElement.getAttribute(attributeRestriction.getKey());
                if (value.isPresent() && attributeRestriction.getValue().equals(value.get())) continue;
                return false;
            }
            return true;
        }
    }

    protected static class XPath {
        @Nonnull
        private final Path path;
        @Nonnull
        private final DependeeExtractor dependeeExtractor;

        protected XPath(@Nonnull Path path, @Nonnull DependeeExtractor dependeeExtractor) {
            this.path = path;
            this.dependeeExtractor = dependeeExtractor;
        }

        public String toString() {
            return this.path.toString() + this.dependeeExtractor.toString();
        }

        @Nonnull
        Optional<String> matchAndExtract(@Nonnull Deque<XmlElement> xmlElements, @Nonnull Optional<String> containedText) {
            int i = xmlElements.size();
            while (i-- > 0) {
                Iterable partialPath = Iterables.skip(xmlElements, (int)i);
                if (!this.path.matches(partialPath)) continue;
                return this.dependeeExtractor.extractDependee(partialPath, containedText);
            }
            return Optional.absent();
        }
    }

    protected static interface DependeeExtractor {
        @Nonnull
        public Optional<String> extractDependee(@Nonnull Iterable<XmlElement> var1, @Nonnull Optional<String> var2);

        public String toString();
    }

    @Immutable
    protected static class XmlElement {
        @Nonnull
        public final String name;
        @Nonnull
        private final Map<String, String> attributes;

        public XmlElement(@Nonnull String name, @Nonnull Attributes attributes) {
            this.name = name;
            HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)attributes.getLength());
            int i = attributes.getLength();
            while (i-- > 0) {
                attributeMap.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            this.attributes = Collections.unmodifiableMap(attributeMap);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.name);
            for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                result.append(attribute.getKey()).append("='").append(attribute.getValue()).append("',");
            }
            if (result.length() > this.name.length()) {
                result.insert(this.name.length(), "[");
                result.replace(result.length() - 1, result.length(), "]");
            }
            return result.toString();
        }

        @Nonnull
        public Optional<String> getAttribute(@Nonnull String name) {
            return Optional.fromNullable((Object)this.attributes.get(name));
        }
    }
}

