/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.IntermediateResults;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HibernateAnnotationsAnalyzer
extends ByteCodeAnalyzer {
    private final Map<String, String> typeDefinitions = Maps.newHashMap();
    private final Map<String, Set<String>> typeUsages = Maps.newHashMap();
    private final Map<String, String> generatorDefinitions = Maps.newHashMap();
    private final Map<String, Set<String>> generatorUsages = Maps.newHashMap();

    @Nonnull
    private static Iterable<Annotation> getAnnotations(@Nonnull CtClass clazz, final @Nonnull String typeName, ElementType ... elementTypes) {
        return Iterables.filter(HibernateAnnotationsAnalyzer.getAnnotations(clazz, elementTypes), (Predicate)new Predicate<Annotation>(){

            public boolean apply(@Nullable Annotation annotation) {
                return annotation != null && typeName.equals(annotation.getTypeName());
            }
        });
    }

    @Nullable
    private static String getStringFrom(@Nonnull Annotation annotation, @Nonnull String memberName) {
        MemberValue memberValue = annotation.getMemberValue(memberName);
        if (memberValue == null) {
            return null;
        }
        Preconditions.checkState((boolean)StringMemberValue.class.isInstance(memberValue), (Object)("The member [" + memberName + "] is no StringMemberValue!"));
        return ((StringMemberValue)StringMemberValue.class.cast(memberValue)).getValue();
    }

    @Nonnull
    private static String getMandatoryStringFrom(@Nonnull Annotation annotation, @Nonnull String memberName) {
        String memberValue = HibernateAnnotationsAnalyzer.getStringFrom(annotation, memberName);
        if (memberValue == null) {
            throw new RuntimeException("Annotation [" + annotation.getTypeName() + "] has no value for mandatory member [" + memberName + "]!");
        }
        return memberValue;
    }

    @Nonnull
    private static Iterable<Annotation> getAnnotationsFrom(@Nonnull Annotation annotation, @Nonnull String memberName) {
        MemberValue memberValue = annotation.getMemberValue(memberName);
        if (memberValue == null) {
            return Collections.emptyList();
        }
        Preconditions.checkState((boolean)ArrayMemberValue.class.isInstance(memberValue), (Object)("The member [" + memberName + "] is no ArrayMemberValue!"));
        MemberValue[] nestedMembers = ((ArrayMemberValue)ArrayMemberValue.class.cast(memberValue)).getValue();
        return Iterables.filter((Iterable)Iterables.transform(Arrays.asList(nestedMembers), (Function)new Function<MemberValue, Annotation>(){

            public Annotation apply(@Nullable MemberValue memberValue) {
                return memberValue == null ? null : ((AnnotationMemberValue)AnnotationMemberValue.class.cast(memberValue)).getValue();
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    protected void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        analysisContext.addAnalyzedClass(clazz.getName());
        this.processTypeDefAnnotation(clazz);
        this.processTypeDefsAnnotation(clazz);
        this.processTypeAnnotations(clazz);
        this.processGenericGenerator(analysisContext, clazz);
        this.processGenericGenerators(analysisContext, clazz);
        this.processGeneratedValueAnnotations(clazz);
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        this.reportDependencies(analysisContext);
        this.storeIntermediateResults(analysisContext);
    }

    private void processTypeDefAnnotation(@Nonnull CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "org.hibernate.annotations.TypeDef", ElementType.PACKAGE, ElementType.TYPE)) {
            this.processTypeDefinition(clazz, annotation);
        }
    }

    private void processTypeDefinition(@Nonnull CtClass clazz, @Nonnull Annotation annotation) {
        String typeName = HibernateAnnotationsAnalyzer.getStringFrom(annotation, "name");
        if (typeName == null) {
            return;
        }
        String className = clazz.getName();
        String previousEntry = this.typeDefinitions.put(typeName, className);
        if (previousEntry != null) {
            this.logger.warn("The @TypeDef named [{}] is defined both by {} and {}.", new Object[]{typeName, previousEntry, className});
        }
    }

    private void processTypeDefsAnnotation(@Nonnull CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "org.hibernate.annotations.TypeDefs", ElementType.PACKAGE, ElementType.TYPE)) {
            for (Annotation childAnnotation : HibernateAnnotationsAnalyzer.getAnnotationsFrom(annotation, "value")) {
                this.processTypeDefinition(clazz, childAnnotation);
            }
        }
    }

    private void processTypeAnnotations(@Nonnull CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "org.hibernate.annotations.Type", ElementType.METHOD, ElementType.FIELD)) {
            String typeName = HibernateAnnotationsAnalyzer.getMandatoryStringFrom(annotation, "type");
            Utils.getOrAddMappedSet(this.typeUsages, typeName).add(clazz.getName());
        }
    }

    private void processGenericGenerator(AnalysisContext analysisContext, CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "org.hibernate.annotations.GenericGenerator", ElementType.PACKAGE, ElementType.TYPE, ElementType.METHOD, ElementType.FIELD)) {
            this.processGenericGenerator(analysisContext, clazz, annotation);
        }
    }

    private void processGenericGenerator(AnalysisContext analysisContext, CtClass clazz, Annotation annotation) {
        String generatorName;
        String previousEntry;
        String className = clazz.getName();
        Optional<String> resolvedStrategyClass = ClassPoolAccessor.classPoolAccessorFor(analysisContext).resolveClass(HibernateAnnotationsAnalyzer.getMandatoryStringFrom(annotation, "strategy"));
        if (resolvedStrategyClass.isPresent()) {
            analysisContext.addDependencies(className, (String)resolvedStrategyClass.get());
        }
        if ((previousEntry = this.generatorDefinitions.put(generatorName = HibernateAnnotationsAnalyzer.getMandatoryStringFrom(annotation, "name"), className)) != null) {
            this.logger.warn("The @GenericGenerator named [{}] is defined both by {} and {}.", new Object[]{generatorName, previousEntry, className});
        }
    }

    private void processGenericGenerators(AnalysisContext analysisContext, CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "org.hibernate.annotations.GenericGenerators", ElementType.PACKAGE, ElementType.TYPE)) {
            for (Annotation childAnnotation : HibernateAnnotationsAnalyzer.getAnnotationsFrom(annotation, "value")) {
                this.processGenericGenerator(analysisContext, clazz, childAnnotation);
            }
        }
    }

    private void processGeneratedValueAnnotations(CtClass clazz) {
        for (Annotation annotation : HibernateAnnotationsAnalyzer.getAnnotations(clazz, "javax.persistence.GeneratedValue", ElementType.METHOD, ElementType.FIELD)) {
            String generatorName = HibernateAnnotationsAnalyzer.getStringFrom(annotation, "generator");
            if (generatorName == null) continue;
            Utils.getOrAddMappedSet(this.generatorUsages, generatorName).add(clazz.getName());
        }
    }

    private void reportDependencies(@Nonnull AnalysisContext analysisContext) {
        this.reportNewGeneratorUsages(analysisContext);
        this.reportExistingGeneratorUsagesForNewDefinitions(analysisContext);
        this.reportNewTypeUsages(analysisContext);
        this.reportExistingTypeUsagesForNewDefinitions(analysisContext);
    }

    private void reportNewGeneratorUsages(AnalysisContext analysisContext) {
        if (this.generatorUsages.isEmpty()) {
            return;
        }
        Map<String, String> allGeneratorDefinitions = this.getAllGeneratorDefinitions(analysisContext);
        for (Map.Entry<String, Set<String>> generatorUsage : this.generatorUsages.entrySet()) {
            String generatorName = generatorUsage.getKey();
            String classDefiningGenerator = allGeneratorDefinitions.get(generatorName);
            if (classDefiningGenerator == null) continue;
            for (String classUsingGenerator : generatorUsage.getValue()) {
                analysisContext.addDependencies(classUsingGenerator, classDefiningGenerator);
            }
        }
    }

    private void reportExistingGeneratorUsagesForNewDefinitions(AnalysisContext analysisContext) {
        if (this.generatorDefinitions.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> usage : this.getExistingGeneratorUsages(analysisContext).entrySet()) {
            String usageName = usage.getKey();
            String classDefiningType = this.generatorDefinitions.get(usageName);
            if (classDefiningType == null) continue;
            this.logger.debug("This module provides the generator definition [{}] for modules it depends on.", (Object)usageName);
            for (String classUsingType : usage.getValue()) {
                analysisContext.addDependencies(classUsingType, classDefiningType);
            }
        }
    }

    private void reportNewTypeUsages(AnalysisContext analysisContext) {
        if (this.typeUsages.isEmpty()) {
            return;
        }
        Map<String, String> allTypeDefinitions = this.getAllTypeDefinitions(analysisContext);
        for (Map.Entry<String, Set<String>> typeUsage : this.typeUsages.entrySet()) {
            String dependee;
            String typeName = typeUsage.getKey();
            String classDefiningType = allTypeDefinitions.get(typeName);
            if (classDefiningType != null) {
                dependee = classDefiningType;
            } else {
                Optional<String> resolvedTypeClass = ClassPoolAccessor.classPoolAccessorFor(analysisContext).resolveClass(typeName);
                if (resolvedTypeClass.isPresent()) {
                    dependee = (String)resolvedTypeClass.get();
                } else {
                    this.logger.debug("Encountered unknown org.hibernate.annotations.Type [{}].", (Object)typeName);
                    continue;
                }
            }
            for (String classUsingType : typeUsage.getValue()) {
                analysisContext.addDependencies(classUsingType, dependee);
            }
        }
    }

    private void reportExistingTypeUsagesForNewDefinitions(AnalysisContext analysisContext) {
        if (this.typeDefinitions.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> typeUsage : this.getExistingTypeUsages(analysisContext).entrySet()) {
            String typeName = typeUsage.getKey();
            String classDefiningType = this.typeDefinitions.get(typeName);
            if (classDefiningType == null) continue;
            this.logger.debug("This module provides the type definition [{}] for modules it depends on.", (Object)typeName);
            for (String classUsingType : typeUsage.getValue()) {
                analysisContext.addDependencies(classUsingType, classDefiningType);
            }
        }
    }

    @Nonnull
    private Map<String, String> getAllGeneratorDefinitions(@Nonnull AnalysisContext analysisContext) {
        IntermediateResults.IntermediateResultMap resultMap = IntermediateResults.resultMapFrom(analysisContext, this.getClass().getName() + "|generatorDefinitions");
        if (resultMap == null) {
            return this.generatorDefinitions;
        }
        Map inheritedDefinitions = resultMap.getResults();
        HashMap allDefinitions = Maps.newHashMap(this.generatorDefinitions);
        for (Map.Entry inheritedDefinition : inheritedDefinitions.entrySet()) {
            String definitionName = (String)inheritedDefinition.getKey();
            if (allDefinitions.containsKey(definitionName)) {
                this.logger.debug("The inherited generator definition [{}] is overridden by this module.", (Object)definitionName);
                continue;
            }
            allDefinitions.put(definitionName, inheritedDefinition.getValue());
        }
        return allDefinitions;
    }

    @Nonnull
    private Map<String, String> getAllTypeDefinitions(@Nonnull AnalysisContext analysisContext) {
        IntermediateResults.IntermediateResultMap resultMap = IntermediateResults.resultMapFrom(analysisContext, this.getClass().getName() + "|typeDefinitions");
        if (resultMap == null) {
            return this.typeDefinitions;
        }
        Map inheritedTypeDefinitions = resultMap.getResults();
        HashMap allTypeDefinitions = Maps.newHashMap(this.typeDefinitions);
        for (Map.Entry inheritedDefinition : inheritedTypeDefinitions.entrySet()) {
            String typeName = (String)inheritedDefinition.getKey();
            if (allTypeDefinitions.containsKey(typeName)) {
                this.logger.debug("The inherited type definition [{}] is overridden by this module.", (Object)typeName);
                continue;
            }
            allTypeDefinitions.put(typeName, inheritedDefinition.getValue());
        }
        return allTypeDefinitions;
    }

    @Nonnull
    private Map<String, Set<String>> getExistingGeneratorUsages(@Nonnull AnalysisContext analysisContext) {
        IntermediateResults.IntermediateResultMap resultMap = IntermediateResults.resultMapFrom(analysisContext, this.getClass().getName() + "|generatorUsages");
        return resultMap != null ? resultMap.getResults() : Collections.emptyMap();
    }

    @Nonnull
    private Map<String, Set<String>> getExistingTypeUsages(@Nonnull AnalysisContext analysisContext) {
        IntermediateResults.IntermediateResultMap resultMap = IntermediateResults.resultMapFrom(analysisContext, this.getClass().getName() + "|typeUsages");
        return resultMap != null ? resultMap.getResults() : Collections.emptyMap();
    }

    private void storeIntermediateResults(@Nonnull AnalysisContext analysisContext) {
        if (!this.generatorDefinitions.isEmpty()) {
            analysisContext.getCache().put(this.getClass().getName() + "|generatorDefinitions", IntermediateResults.resultMapFor(this.generatorDefinitions));
            this.generatorDefinitions.clear();
        }
        if (!this.generatorUsages.isEmpty()) {
            analysisContext.getCache().put(this.getClass().getName() + "|generatorUsages", IntermediateResults.resultMapFor(this.generatorUsages));
            this.generatorUsages.clear();
        }
        if (!this.typeDefinitions.isEmpty()) {
            analysisContext.getCache().put(this.getClass().getName() + "|typeDefinitions", IntermediateResults.resultMapFor(this.typeDefinitions));
            this.typeDefinitions.clear();
        }
        if (!this.typeUsages.isEmpty()) {
            analysisContext.getCache().put(this.getClass().getName() + "|typeUsages", IntermediateResults.resultMapFor(this.typeUsages));
            this.typeUsages.clear();
        }
    }
}

