/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.AnalysisSink;
import de.is24.deadcode4j.AnalyzedCode;
import de.is24.deadcode4j.DeadCodeComputer;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import java.util.ArrayList;
import java.util.Set;
import javassist.CtClass;
import javax.annotation.Nonnull;

public class IgnoreClassesAnalyzer
extends ByteCodeAnalyzer {
    @Nonnull
    private final DeadCodeComputer deadCodeComputer;
    @Nonnull
    private final Set<String> classesToIgnore;
    @Nonnull
    private final Set<String> ignoredClasses;

    public IgnoreClassesAnalyzer(@Nonnull DeadCodeComputer deadCodeComputer, @Nonnull Set<String> classesToIgnore) {
        this.deadCodeComputer = deadCodeComputer;
        this.classesToIgnore = Sets.newHashSet(classesToIgnore);
        this.ignoredClasses = Sets.newHashSetWithExpectedSize((int)classesToIgnore.size());
    }

    @Override
    protected void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        String className = clazz.getName();
        analysisContext.addAnalyzedClass(className);
        if (this.classesToIgnore.contains(className)) {
            this.ignoredClasses.add(className);
        }
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisSink analysisSink, @Nonnull AnalyzedCode analyzedCode) {
        this.logUnknownClassesThatShouldBeIgnored();
        this.logLiveClassesThatShouldBeIgnored(analyzedCode);
        this.logIgnoredClasses();
        analysisSink.addDependencies("_IgnoredClasses_", this.ignoredClasses);
    }

    private void logUnknownClassesThatShouldBeIgnored() {
        ArrayList ignoredButUnknownClasses = Lists.newArrayList(this.classesToIgnore);
        ignoredButUnknownClasses.removeAll(this.ignoredClasses);
        for (String ignoredButUnknownClass : ignoredButUnknownClasses) {
            this.logger.warn("Class [{}] should be ignored, but does not exist. You should remove the configuration entry.", (Object)ignoredButUnknownClass);
        }
    }

    private void logLiveClassesThatShouldBeIgnored(@Nonnull AnalyzedCode analyzedCode) {
        ArrayList ignoredButExistingClasses = Lists.newArrayList(this.ignoredClasses);
        ignoredButExistingClasses.removeAll(this.deadCodeComputer.computeDeadCode(analyzedCode).getDeadClasses());
        for (String ignoredButExistingClass : ignoredButExistingClasses) {
            this.logger.warn("Class [{}] should be ignored, but is not dead. You should remove the configuration entry.", (Object)ignoredButExistingClass);
            this.ignoredClasses.remove(ignoredButExistingClass);
        }
    }

    private void logIgnoredClasses() {
        if (this.ignoredClasses.size() != 0) {
            this.logger.info("Ignoring {} class(es) which seem(s) to be unused.", (Object)this.ignoredClasses.size());
        }
    }
}

