/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import de.is24.deadcode4j.analyzer.javassist.ClassPathFilter;
import de.is24.guava.NonNullFunction;
import de.is24.javassist.CtClasses;
import java.util.Collections;
import java.util.Set;
import javassist.CtClass;
import javax.annotation.Nonnull;

public abstract class InterfacesAnalyzer
extends ByteCodeAnalyzer {
    @Nonnull
    private final String dependerId;
    private final NonNullFunction<AnalysisContext, Set<String>> supplyInterfacesFoundInClassPath;

    private InterfacesAnalyzer(@Nonnull String dependerId, @Nonnull Set<String> interfaceNames) {
        Preconditions.checkArgument((!interfaceNames.isEmpty() ? 1 : 0) != 0, (Object)"interfaceNames cannot by empty!");
        this.dependerId = dependerId;
        this.supplyInterfacesFoundInClassPath = new ClassPathFilter(interfaceNames);
    }

    protected InterfacesAnalyzer(@Nonnull String dependerId, String ... interfaceNames) {
        this(dependerId, Sets.newHashSet((Object[])interfaceNames));
    }

    protected InterfacesAnalyzer(@Nonnull String dependerId, @Nonnull Iterable<String> interfaceNames) {
        this(dependerId, Sets.newHashSet(interfaceNames));
    }

    @Override
    protected final void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        Set<String> knownInterfaces = this.getInterfacesFoundInClassPath(analysisContext);
        if (knownInterfaces.isEmpty()) {
            return;
        }
        String clazzName = clazz.getName();
        analysisContext.addAnalyzedClass(clazzName);
        if (!Collections.disjoint(knownInterfaces, CtClasses.getAllImplementedInterfaces(clazz))) {
            analysisContext.addDependencies(this.dependerId, clazzName);
        }
    }

    @Nonnull
    protected final Set<String> getInterfacesFoundInClassPath(@Nonnull AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(this.getClass(), this.supplyInterfacesFoundInClassPath);
    }
}

