/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.TokenMgrError;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.AnalyzerAdapter;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import de.is24.guava.NonNullFunction;
import de.is24.guava.NonNullFunctions;
import de.is24.guava.SequentialLoadingCache;
import de.is24.javaparser.ImportDeclarations;
import de.is24.javaparser.Nodes;
import de.is24.javassist.CtClasses;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import javassist.CtClass;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaFileAnalyzer
extends AnalyzerAdapter {
    private static final String JAVA_PARSER_KEY = JavaFileAnalyzer.class.getName() + ":JavaParser";
    private static final NonNullFunction<AnalysisContext, LoadingCache<File, Optional<CompilationUnit>>> JAVA_PARSER_SUPPLIER = new JavaParserSupplier(true);
    private static final String TYPE_RESOLVER_KEY = JavaFileAnalyzer.class.getName() + ":TypeResolver";
    private static final NonNullFunction<AnalysisContext, NonNullFunction<Qualifier<?>, Optional<String>>> TYPE_RESOLVER_SUPPLIER = new NonNullFunction<AnalysisContext, NonNullFunction<Qualifier<?>, Optional<String>>>(){

        @Override
        @Nonnull
        public NonNullFunction<Qualifier<?>, Optional<String>> apply(@Nonnull AnalysisContext analysisContext) {
            final ClassPoolAccessor classPoolAccessor = ClassPoolAccessor.classPoolAccessorFor(analysisContext);
            return new NonNullFunction<Qualifier<?>, Optional<String>>(){

                @Override
                @Nonnull
                public Optional<String> apply(@Nonnull Qualifier<?> input) {
                    return NonNullFunctions.or(new FullyQualifiedTypeResolver(classPoolAccessor), new InnerTypeResolver(), new InheritedTypeResolver(classPoolAccessor), new ImportedTypeResolver(classPoolAccessor), new PackageTypeResolver(classPoolAccessor), new AsteriskImportedTypeResolver(classPoolAccessor), new JavaLangTypeResolver(classPoolAccessor)).apply(input);
                }
            };
        }
    };

    private static LoadingCache<File, Optional<CompilationUnit>> getJavaFileParser(AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(JAVA_PARSER_KEY, JAVA_PARSER_SUPPLIER);
    }

    private static NonNullFunction<Qualifier<?>, Optional<String>> getTypeResolver(AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(TYPE_RESOLVER_KEY, TYPE_RESOLVER_SUPPLIER);
    }

    @Nonnull
    protected static Optional<String> resolveType(@Nonnull AnalysisContext analysisContext, @Nonnull Qualifier qualifier) {
        Optional<String> resolvedClass = JavaFileAnalyzer.getTypeResolver(analysisContext).apply(qualifier);
        if (!qualifier.allowsPartialResolving() && resolvedClass.isPresent() && !JavaFileAnalyzer.isFullyResolved((String)resolvedClass.get(), qualifier)) {
            return Optional.absent();
        }
        return resolvedClass;
    }

    protected static boolean isFullyResolved(@Nonnull String resolvedClass, @Nonnull Qualifier qualifier) {
        return resolvedClass.replace('$', '.').endsWith(qualifier.getFullQualifier().replace('$', '.'));
    }

    @Override
    public final void doAnalysis(@Nonnull AnalysisContext analysisContext, @Nonnull File file) {
        Optional compilationUnit;
        if (file.getName().endsWith(".java") && (compilationUnit = (Optional)JavaFileAnalyzer.getJavaFileParser(analysisContext).getUnchecked((Object)file)).isPresent()) {
            this.logger.debug("Analyzing Java file [{}]...", (Object)file);
            this.analyzeCompilationUnit(analysisContext, (CompilationUnit)compilationUnit.get());
        }
    }

    protected abstract void analyzeCompilationUnit(@Nonnull AnalysisContext var1, @Nonnull CompilationUnit var2);

    private static class JavaParserSupplier
    implements NonNullFunction<AnalysisContext, LoadingCache<File, Optional<CompilationUnit>>> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final boolean ignoreParsingErrors;

        JavaParserSupplier(boolean ignoreParsingErrors) {
            this.ignoreParsingErrors = ignoreParsingErrors;
        }

        @Override
        @Nonnull
        public LoadingCache<File, Optional<CompilationUnit>> apply(final @Nonnull AnalysisContext analysisContext) {
            return SequentialLoadingCache.createSingleValueCache(NonNullFunctions.toFunction(new NonNullFunction<File, Optional<CompilationUnit>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Nonnull
                @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="The MavenProject does not provide the proper encoding")
                public Optional<CompilationUnit> apply(@Nonnull File file) {
                    Optional optional;
                    InputStreamReader reader = null;
                    try {
                        reader = analysisContext.getModule().getEncoding() != null ? new InputStreamReader((InputStream)new FileInputStream(file), analysisContext.getModule().getEncoding()) : new FileReader(file);
                        optional = Optional.of((Object)JavaParser.parse((Reader)reader, (boolean)false));
                    }
                    catch (Throwable t) {
                        Optional optional2;
                        try {
                            optional2 = JavaParserSupplier.this.handleThrowable(file, t);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(reader);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Reader)reader);
                        return optional2;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    return optional;
                }
            }));
        }

        private Optional<CompilationUnit> handleThrowable(File file, Throwable t) {
            String message = "Failed to parse [" + file + "]!";
            if ((TokenMgrError.class.isInstance(t) || ParseException.class.isInstance(t)) && this.ignoreParsingErrors) {
                this.logger.debug(message, t);
                return Optional.absent();
            }
            if (Error.class.isInstance(t) && !TokenMgrError.class.isInstance(t)) {
                throw (Error)Error.class.cast(t);
            }
            throw new RuntimeException(message, t);
        }
    }

    private static class JavaLangTypeResolver
    extends CandidatesResolver {
        public JavaLangTypeResolver(@Nonnull ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nonnull
        protected String calculatePrefix(@Nonnull Qualifier<?> topQualifier) {
            return "java.lang.";
        }
    }

    private static class AsteriskImportedTypeResolver
    extends CandidatesResolver {
        public AsteriskImportedTypeResolver(@Nonnull ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nonnull
        protected Iterable<String> calculatePrefixes(@Nonnull Qualifier<?> topQualifier) {
            ArrayList asteriskImports = Lists.newArrayList();
            CompilationUnit compilationUnit = Nodes.getCompilationUnit(topQualifier.getNode());
            for (ImportDeclaration importDeclaration : Utils.emptyIfNull(compilationUnit.getImports()).filter(ImportDeclarations.isAsterisk())) {
                StringBuilder buffy = Nodes.prepend(importDeclaration.getName(), new StringBuilder());
                buffy.append(importDeclaration.isStatic() ? (char)'$' : '.');
                asteriskImports.add(buffy.toString());
            }
            return asteriskImports;
        }
    }

    private static class PackageTypeResolver
    extends CandidatesResolver {
        public PackageTypeResolver(@Nonnull ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nonnull
        protected String calculatePrefix(@Nonnull Qualifier<?> topQualifier) {
            PackageDeclaration aPackage = Nodes.getCompilationUnit(topQualifier.getNode()).getPackage();
            if (aPackage == null) {
                return "";
            }
            return Nodes.prepend(aPackage.getName(), new StringBuilder("")).append(".").toString();
        }
    }

    private static class ImportedTypeResolver
    extends CandidatesResolver {
        public ImportedTypeResolver(ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nullable
        protected String calculatePrefix(@Nonnull Qualifier<?> topQualifier) {
            String firstQualifier = topQualifier.getFirstQualifier().getName();
            CompilationUnit compilationUnit = Nodes.getCompilationUnit(topQualifier.getNode());
            ImportDeclaration importDeclaration = (ImportDeclaration)Iterables.getOnlyElement((Iterable)Utils.emptyIfNull(compilationUnit.getImports()).filter(Predicates.and((Predicate)Predicates.not(ImportDeclarations.isAsterisk()), ImportDeclarations.refersTo(firstQualifier))), null);
            if (importDeclaration == null) {
                return null;
            }
            StringBuilder buffy = Nodes.prepend(importDeclaration.getName(), new StringBuilder());
            int beginIndex = buffy.length() - firstQualifier.length();
            return beginIndex == 0 ? "" : buffy.replace(beginIndex - 1, buffy.length(), importDeclaration.isStatic() ? "$" : ".").toString();
        }
    }

    private static class InheritedTypeResolver
    extends RequiresClassPoolAccessor
    implements NonNullFunction<Qualifier<?>, Optional<String>> {
        public InheritedTypeResolver(@Nonnull ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nonnull
        public Optional<String> apply(@Nonnull Qualifier<?> typeReference) {
            String typeName = Nodes.getTypeName(typeReference.getNode());
            CtClass clazz = CtClasses.getCtClass(this.classPoolAccessor.getClassPool(), typeName);
            if (clazz == null) {
                return Optional.absent();
            }
            Qualifier<?> firstQualifier = typeReference.getFirstQualifier();
            for (CtClass declaringClazz : CtClasses.getDeclaringClassesOf(clazz)) {
                Optional<String> inheritedType = this.resolveInheritedType(clazz, declaringClazz, firstQualifier);
                if (!inheritedType.isPresent()) continue;
                return inheritedType;
            }
            return Optional.absent();
        }

        @Nonnull
        private Optional<String> resolveInheritedType(@Nonnull CtClass referencingClazz, @Nonnull CtClass clazz, @Nonnull Qualifier firstQualifier) {
            Optional<String> result = firstQualifier.examineInheritedType(referencingClazz, clazz);
            if (result.isPresent()) {
                return result;
            }
            result = this.checkNestedClasses(referencingClazz, CtClasses.getSuperclassOf(clazz), firstQualifier);
            if (result.isPresent()) {
                return result;
            }
            for (CtClass interfaceClazz : CtClasses.getInterfacesOf(clazz)) {
                result = this.checkNestedClasses(referencingClazz, interfaceClazz, firstQualifier);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.absent();
        }

        @Nonnull
        private Optional<String> checkNestedClasses(@Nonnull CtClass referencingClazz, @Nullable CtClass clazz, @Nonnull Qualifier firstQualifier) {
            if (clazz == null || CtClasses.isJavaLangObject(clazz)) {
                return Optional.absent();
            }
            for (CtClass nestedClass : CtClasses.getNestedClassesOf(clazz)) {
                if (!nestedClass.getName().substring(clazz.getName().length() + 1).equals(firstQualifier.getName())) continue;
                return this.resolveNestedType(firstQualifier, nestedClass);
            }
            return this.resolveInheritedType(referencingClazz, clazz, firstQualifier);
        }

        private Optional<String> resolveNestedType(Qualifier qualifier, CtClass clazz) {
            Qualifier<?> parentQualifier = qualifier.getParentQualifier();
            if (parentQualifier != null) {
                for (CtClass nestedClass : CtClasses.getNestedClassesOf(clazz)) {
                    if (!nestedClass.getName().substring(clazz.getName().length() + 1).equals(parentQualifier.getName())) continue;
                    return this.resolveNestedType(parentQualifier, nestedClass);
                }
            }
            return Optional.of((Object)clazz.getName());
        }
    }

    private static class InnerTypeResolver
    implements NonNullFunction<Qualifier<?>, Optional<String>> {
        private InnerTypeResolver() {
        }

        @Override
        @Nonnull
        public Optional<String> apply(@Nonnull Qualifier<?> typeReference) {
            Qualifier<?> firstQualifier = typeReference.getFirstQualifier();
            Object loopNode = typeReference.getNode();
            do {
                Optional<String> reference;
                if (TypeDeclaration.class.isInstance(loopNode)) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)TypeDeclaration.class.cast(loopNode);
                    reference = this.resolveInnerReference(firstQualifier, Collections.singleton(typeDeclaration));
                    if (reference.isPresent()) {
                        return reference;
                    }
                    reference = this.resolveInnerReference(firstQualifier, typeDeclaration.getMembers());
                    if (!reference.isPresent()) continue;
                    return reference;
                }
                if (!CompilationUnit.class.isInstance(loopNode) || !(reference = this.resolveInnerReference(firstQualifier, ((CompilationUnit)CompilationUnit.class.cast(loopNode)).getTypes())).isPresent()) continue;
                return reference;
            } while ((loopNode = loopNode.getParentNode()) != null);
            return Optional.absent();
        }

        @Nonnull
        private Optional<String> resolveInnerReference(@Nonnull Qualifier firstQualifier, @Nullable Iterable<? extends BodyDeclaration> bodyDeclarations) {
            for (TypeDeclaration typeDeclaration : Utils.emptyIfNull(bodyDeclarations).filter(TypeDeclaration.class)) {
                if (!firstQualifier.getName().equals(typeDeclaration.getName())) continue;
                return Optional.of((Object)this.resolveReferencedType(firstQualifier, typeDeclaration));
            }
            return Optional.absent();
        }

        @Nonnull
        private String resolveReferencedType(@Nonnull Qualifier qualifier, @Nonnull TypeDeclaration type) {
            Qualifier<?> parentQualifier = qualifier.getParentQualifier();
            if (parentQualifier != null) {
                for (TypeDeclaration innerType : Utils.emptyIfNull(type.getMembers()).filter(TypeDeclaration.class)) {
                    if (!parentQualifier.getName().equals(innerType.getName())) continue;
                    return this.resolveReferencedType(parentQualifier, innerType);
                }
            }
            return Nodes.getTypeName((Node)type);
        }
    }

    private static class FullyQualifiedTypeResolver
    extends CandidatesResolver {
        public FullyQualifiedTypeResolver(ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Override
        @Nonnull
        protected String calculatePrefix(@Nonnull Qualifier<?> topQualifier) {
            return "";
        }

        @Override
        protected boolean skipResolvingFor(@Nonnull Qualifier<?> candidate) {
            return candidate.isSingleQualifier();
        }
    }

    private static abstract class CandidatesResolver
    extends RequiresClassPoolAccessor
    implements NonNullFunction<Qualifier<?>, Optional<String>> {
        protected CandidatesResolver(@Nonnull ClassPoolAccessor classPoolAccessor) {
            super(classPoolAccessor);
        }

        @Nonnull
        protected Iterable<String> calculatePrefixes(@Nonnull Qualifier<?> topQualifier) {
            String prefix = this.calculatePrefix(topQualifier);
            return prefix != null ? Collections.singletonList(prefix) : Collections.emptyList();
        }

        @Nullable
        protected String calculatePrefix(@Nonnull Qualifier<?> topQualifier) {
            return null;
        }

        protected boolean skipResolvingFor(@Nonnull Qualifier<?> candidate) {
            return false;
        }

        @Override
        @Nonnull
        public final Optional<String> apply(@Nonnull Qualifier<?> input) {
            for (CharSequence charSequence : this.calculatePrefixes(input)) {
                for (Qualifier candidate : input.getTypeCandidates()) {
                    Optional<String> resolvedClass;
                    if (this.skipResolvingFor(candidate) || !(resolvedClass = this.classPoolAccessor.resolveClass(charSequence + candidate.getFullQualifier())).isPresent()) continue;
                    return resolvedClass;
                }
            }
            return Optional.absent();
        }
    }

    private static abstract class RequiresClassPoolAccessor {
        @Nonnull
        protected final ClassPoolAccessor classPoolAccessor;

        protected RequiresClassPoolAccessor(@Nonnull ClassPoolAccessor classPoolAccessor) {
            this.classPoolAccessor = classPoolAccessor;
        }
    }

    protected static abstract class Qualifier<T extends Node> {
        @Nonnull
        private final T reference;
        @Nonnull
        private final String name;
        @Nonnull
        private final String fullQualifier;
        @Nullable
        private final Qualifier<?> parentQualifier;
        @Nullable
        private final Qualifier<?> scopeQualifier;

        protected Qualifier(@Nonnull T reference, @Nullable Qualifier<?> parent) {
            this.reference = reference;
            this.parentQualifier = parent;
            this.scopeQualifier = this.getScopeQualifier(reference);
            this.name = this.getName(reference);
            this.fullQualifier = this.getFullQualifier(reference);
        }

        protected Qualifier(@Nonnull T reference) {
            this(reference, null);
        }

        @Nonnull
        protected abstract String getName(@Nonnull T var1);

        @Nonnull
        protected abstract String getFullQualifier(@Nonnull T var1);

        @Nullable
        protected abstract Qualifier<?> getScopeQualifier(@Nonnull T var1);

        protected abstract boolean allowsPartialResolving();

        @Nonnull
        protected final T getNode() {
            return this.reference;
        }

        @Nonnull
        protected final String getName() {
            return this.name;
        }

        @Nonnull
        protected final String getFullQualifier() {
            return this.fullQualifier;
        }

        @Nullable
        protected final Qualifier<?> getParentQualifier() {
            return this.parentQualifier;
        }

        @Nullable
        protected final Qualifier<?> getScopeQualifier() {
            return this.scopeQualifier;
        }

        @Nonnull
        protected final Qualifier<?> getFirstQualifier() {
            Qualifier<?> currentScope = this;
            Qualifier<?> nextScope;
            while ((nextScope = currentScope.getScopeQualifier()) != null) {
                currentScope = nextScope;
            }
            return currentScope;
        }

        protected final boolean isSingleQualifier() {
            return this == this.getFirstQualifier();
        }

        @Nonnull
        protected final Iterable<? extends Qualifier> getTypeCandidates() {
            if (!this.allowsPartialResolving()) {
                return Collections.singleton(this);
            }
            ArrayList candidates = Lists.newArrayList();
            Qualifier<?> loopQualifier = this;
            do {
                candidates.add(loopQualifier);
            } while ((loopQualifier = loopQualifier.getScopeQualifier()) != null);
            return candidates;
        }

        @Nonnull
        protected Optional<String> examineInheritedType(@Nonnull CtClass referencingClazz, @Nonnull CtClass inheritedClazz) {
            return Optional.absent();
        }
    }
}

