/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Iterables;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import javassist.CtClass;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.MethodInfo;
import javax.annotation.Nonnull;

public class MainClassAnalyzer
extends ByteCodeAnalyzer {
    private static boolean isPublicStatic(MethodInfo methodInfo) {
        int modifier = AccessFlag.toModifier((int)methodInfo.getAccessFlags());
        return Modifier.isPublic((int)modifier) && Modifier.isStatic((int)modifier);
    }

    private static boolean matchesSignature(MethodInfo methodInfo) {
        return "([Ljava/lang/String;)V".equals(methodInfo.getDescriptor());
    }

    @Override
    protected void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        String clazzName = clazz.getName();
        analysisContext.addAnalyzedClass(clazzName);
        for (MethodInfo methodInfo : Iterables.filter((Iterable)clazz.getClassFile2().getMethods(), MethodInfo.class)) {
            if (!methodInfo.isMethod() || !MainClassAnalyzer.isPublicStatic(methodInfo) || !"main".equals(methodInfo.getName()) || !MainClassAnalyzer.matchesSignature(methodInfo)) continue;
            analysisContext.addDependencies("_Main-Class_", clazz.getName());
        }
    }
}

