/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.ModifierSet;
import com.github.javaparser.ast.body.MultiTypeParameter;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.JavaFileAnalyzer;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import de.is24.javaparser.ImportDeclarations;
import de.is24.javaparser.Nodes;
import de.is24.javassist.CtClasses;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReferenceToConstantsAnalyzer
extends JavaFileAnalyzer {
    @Nonnull
    private static String getFirstElement(@Nonnull FieldAccessExpr fieldAccessExpr) {
        return ReferenceToConstantsAnalyzer.getFirstNode(fieldAccessExpr).getName();
    }

    @Nonnull
    private static NameExpr getFirstNode(@Nonnull FieldAccessExpr fieldAccessExpr) {
        Expression scope = fieldAccessExpr.getScope();
        if (NameExpr.class.isInstance(scope)) {
            return (NameExpr)NameExpr.class.cast(scope);
        }
        if (FieldAccessExpr.class.isInstance(scope)) {
            return ReferenceToConstantsAnalyzer.getFirstNode((FieldAccessExpr)FieldAccessExpr.class.cast(scope));
        }
        throw new RuntimeException("Should not have reached this point!");
    }

    private static boolean isRegularFieldAccessExpr(@Nonnull FieldAccessExpr fieldAccessExpr) {
        Expression scope = fieldAccessExpr.getScope();
        if (NameExpr.class.isInstance(scope)) {
            return true;
        }
        if (FieldAccessExpr.class.isInstance(scope)) {
            return ReferenceToConstantsAnalyzer.isRegularFieldAccessExpr((FieldAccessExpr)FieldAccessExpr.class.cast(scope));
        }
        return false;
    }

    private static String getFullQualifier(FieldAccessExpr reference) {
        StringBuilder buffy = new StringBuilder(reference.getField());
        FieldAccessExpr loop = reference;
        while (loop != null) {
            String qualifier;
            Expression scope = loop.getScope();
            if (NameExpr.class.isInstance(scope)) {
                loop = null;
                qualifier = ((NameExpr)NameExpr.class.cast(scope)).getName();
            } else {
                loop = (FieldAccessExpr)FieldAccessExpr.class.cast(scope);
                qualifier = loop.getField();
            }
            buffy.insert(0, '.');
            buffy.insert(0, qualifier);
        }
        return buffy.toString();
    }

    private static boolean isScopeOfAMethodCall(@Nonnull Expression expression) {
        return MethodCallExpr.class.isInstance(expression.getParentNode()) && expression == ((MethodCallExpr)MethodCallExpr.class.cast(expression.getParentNode())).getScope();
    }

    private static boolean isScopeOfThisExpression(@Nonnull Expression expression) {
        return ThisExpr.class.isInstance(expression.getParentNode());
    }

    private static boolean isTargetOfAnAssignment(@Nonnull Expression expression) {
        return AssignExpr.class.isInstance(expression.getParentNode()) && expression == ((AssignExpr)AssignExpr.class.cast(expression.getParentNode())).getTarget();
    }

    private static Function<? super ImportDeclaration, ? extends String> toImportedType() {
        return new Function<ImportDeclaration, String>(){

            @Nullable
            public String apply(@Nullable ImportDeclaration input) {
                if (input == null) {
                    return null;
                }
                NameExpr name = input.getName();
                if (input.isStatic() && !input.isAsterisk()) {
                    name = ((QualifiedNameExpr)QualifiedNameExpr.class.cast(name)).getQualifier();
                }
                return name.toString();
            }
        };
    }

    private static boolean isConstant(CtField ctField) {
        return Modifier.isStatic((int)ctField.getModifiers()) && Modifier.isFinal((int)ctField.getModifiers());
    }

    @Override
    protected void analyzeCompilationUnit(final @Nonnull AnalysisContext analysisContext, final @Nonnull CompilationUnit compilationUnit) {
        compilationUnit.accept((VoidVisitor)new LocalVariableRecordingVisitor<Void>(){
            private final ClassPoolAccessor classPoolAccessor;
            private final Map<String, Set<String>> processedReferences;
            {
                this.classPoolAccessor = ClassPoolAccessor.classPoolAccessorFor(analysisContext);
                this.processedReferences = Maps.newHashMap();
            }

            public void visit(FieldAccessExpr n, Void arg) {
                if (ReferenceToConstantsAnalyzer.isTargetOfAnAssignment((Expression)n) || ReferenceToConstantsAnalyzer.isScopeOfThisExpression((Expression)n)) {
                    return;
                }
                if (!ReferenceToConstantsAnalyzer.isRegularFieldAccessExpr(n)) {
                    super.visit(n, (Object)arg);
                    return;
                }
                if (this.aLocalVariableExists(ReferenceToConstantsAnalyzer.getFirstElement(n))) {
                    return;
                }
                this.resolveFieldReference(n);
            }

            public void visit(NameExpr n, Void arg) {
                if (ReferenceToConstantsAnalyzer.isTargetOfAnAssignment((Expression)n) || ReferenceToConstantsAnalyzer.isScopeOfThisExpression((Expression)n) || this.aLocalVariableExists(n.getName())) {
                    return;
                }
                this.resolveNameReference(n);
            }

            private Optional<String> resolveClass(String qualifier) {
                return this.classPoolAccessor.resolveClass(qualifier);
            }

            private void resolveFieldReference(FieldAccessExpr reference) {
                Optional<String> resolvedType;
                if (!this.needsProcessing(reference)) {
                    return;
                }
                if (ReferenceToConstantsAnalyzer.isScopeOfAMethodCall((Expression)reference)) {
                    FieldAccessExprQualifier qualifier = new FieldAccessExprQualifier(reference);
                    resolvedType = JavaFileAnalyzer.resolveType(analysisContext, qualifier);
                    if (resolvedType.isPresent() && JavaFileAnalyzer.isFullyResolved((String)resolvedType.get(), qualifier)) {
                        return;
                    }
                } else {
                    resolvedType = JavaFileAnalyzer.resolveType(analysisContext, this.qualifierFor(reference));
                }
                String referencingType = Nodes.getTypeName((Node)reference);
                if (resolvedType.isPresent()) {
                    analysisContext.addDependencies(referencingType, (String)resolvedType.get());
                } else {
                    ReferenceToConstantsAnalyzer.this.logger.debug("Could not resolve reference [{}] found within [{}].", (Object)reference, (Object)referencingType);
                }
            }

            private boolean needsProcessing(FieldAccessExpr fieldAccessExpr) {
                Set<String> references = Utils.getOrAddMappedSet(this.processedReferences, Nodes.getTypeName((Node)fieldAccessExpr));
                return references.add(ReferenceToConstantsAnalyzer.getFullQualifier(fieldAccessExpr));
            }

            private JavaFileAnalyzer.Qualifier qualifierFor(FieldAccessExpr fieldAccessExpr) {
                Expression scope = fieldAccessExpr.getScope();
                return NameExpr.class.isInstance(scope) ? new NameExprQualifier((NameExpr)NameExpr.class.cast(scope)) : new FieldAccessExprQualifier((FieldAccessExpr)FieldAccessExpr.class.cast(scope));
            }

            private void resolveNameReference(NameExpr reference) {
                if (!this.needsProcessing(reference)) {
                    return;
                }
                if (ReferenceToConstantsAnalyzer.isScopeOfAMethodCall((Expression)reference) && JavaFileAnalyzer.resolveType(analysisContext, new NameExprQualifier(reference)).isPresent()) {
                    return;
                }
                if (this.refersToInheritedField(reference) || this.refersToStaticImport(reference) || this.refersToAsteriskStaticImport(reference)) {
                    return;
                }
                if (SwitchEntryStmt.class.isInstance(reference.getParentNode())) {
                    return;
                }
                ReferenceToConstantsAnalyzer.this.logger.debug("Could not resolve name reference [{}] found within [{}].", (Object)reference, (Object)Nodes.getTypeName((Node)reference));
            }

            private boolean needsProcessing(NameExpr nameExpr) {
                Set<String> references = Utils.getOrAddMappedSet(this.processedReferences, Nodes.getTypeName((Node)nameExpr));
                return references.add(nameExpr.getName());
            }

            private boolean refersToInheritedField(NameExpr reference) {
                CtClass referencingClazz = CtClasses.getCtClass(this.classPoolAccessor.getClassPool(), Nodes.getTypeName((Node)reference));
                if (referencingClazz == null) {
                    return false;
                }
                for (CtClass declaringClazz : CtClasses.getDeclaringClassesOf(referencingClazz)) {
                    if (!this.refersToInheritedField(referencingClazz, declaringClazz, reference)) continue;
                    return true;
                }
                return false;
            }

            private boolean refersToInheritedField(@Nonnull CtClass referencingClazz, @Nullable CtClass clazz, @Nonnull NameExpr reference) {
                if (clazz == null || CtClasses.isJavaLangObject(clazz)) {
                    return false;
                }
                for (CtField ctField : clazz.getDeclaredFields()) {
                    if (!ctField.getName().equals(reference.getName()) || !this.fieldIsVisibleFrom(ctField, referencingClazz)) continue;
                    if (ReferenceToConstantsAnalyzer.isConstant(ctField)) {
                        analysisContext.addDependencies(referencingClazz.getName(), clazz.getName());
                    }
                    return true;
                }
                if (this.refersToInheritedField(referencingClazz, CtClasses.getSuperclassOf(clazz), reference)) {
                    return true;
                }
                for (CtClass interfaceClazz : CtClasses.getInterfacesOf(clazz)) {
                    if (!this.refersToInheritedField(referencingClazz, interfaceClazz, reference)) continue;
                    return true;
                }
                return false;
            }

            private boolean fieldIsVisibleFrom(CtField ctField, CtClass referencingClazz) {
                return ctField.visibleFrom(referencingClazz) || this.isNestedClass(referencingClazz, ctField.getDeclaringClass()) && (this.isStaticField(ctField) || !this.isStaticClass(referencingClazz));
            }

            private boolean isNestedClass(CtClass nestedClass, CtClass parentClass) {
                return nestedClass.getName().startsWith(parentClass.getName() + "$");
            }

            private boolean isStaticClass(CtClass referencingClazz) {
                return Modifier.isStatic((int)referencingClazz.getModifiers());
            }

            private boolean isStaticField(CtField ctField) {
                return Modifier.isStatic((int)ctField.getModifiers());
            }

            private boolean refersToStaticImport(NameExpr reference) {
                String referenceName = reference.getName();
                String staticImport = this.getStaticImport(referenceName);
                if (staticImport == null) {
                    return false;
                }
                String typeName = Nodes.getTypeName((Node)reference);
                Optional<String> resolvedClass = this.resolveClass(staticImport);
                if (resolvedClass.isPresent()) {
                    analysisContext.addDependencies(typeName, (String)resolvedClass.get());
                } else {
                    ReferenceToConstantsAnalyzer.this.logger.warn("Could not resolve static import [{}.{}] found within [{}]!", new Object[]{staticImport, referenceName, typeName});
                }
                return true;
            }

            private boolean refersToAsteriskStaticImport(NameExpr reference) {
                CtClass referencingClazz = CtClasses.getCtClass(this.classPoolAccessor.getClassPool(), Nodes.getTypeName((Node)reference));
                if (referencingClazz == null) {
                    return false;
                }
                for (String asteriskImport : this.getStaticAsteriskImports()) {
                    Optional<String> resolvedClass = this.resolveClass(asteriskImport);
                    if (!resolvedClass.isPresent()) {
                        String typeName = Nodes.getTypeName((Node)reference);
                        ReferenceToConstantsAnalyzer.this.logger.warn("Could not resolve static import [{}.*] found within [{}]!", (Object)asteriskImport, (Object)typeName);
                        continue;
                    }
                    CtClass potentialTarget = CtClasses.getCtClass(this.classPoolAccessor.getClassPool(), (String)resolvedClass.get());
                    if (!this.refersToInheritedField(referencingClazz, potentialTarget, reference)) continue;
                    return true;
                }
                return false;
            }

            @Nullable
            private String getStaticImport(String referenceName) {
                return (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)Iterables.filter(Utils.emptyIfNull(compilationUnit.getImports()), (Predicate)Predicates.and((Predicate[])new Predicate[]{ImportDeclarations.refersTo(referenceName), Predicates.not(ImportDeclarations.isAsterisk()), ImportDeclarations.isStatic()})), (Function)ReferenceToConstantsAnalyzer.toImportedType()), null);
            }

            @Nonnull
            private Iterable<String> getStaticAsteriskImports() {
                return Iterables.transform((Iterable)Iterables.filter(Utils.emptyIfNull(compilationUnit.getImports()), (Predicate)Predicates.and(ImportDeclarations.isAsterisk(), ImportDeclarations.isStatic())), (Function)ReferenceToConstantsAnalyzer.toImportedType());
            }

            public void visit(ClassOrInterfaceType n, Void arg) {
            }

            public void visit(CompilationUnit n, Void arg) {
                for (TypeDeclaration typeDeclaration : Utils.emptyIfNull(n.getTypes())) {
                    typeDeclaration.accept((VoidVisitor)this, (Object)arg);
                }
            }

            public void visit(MarkerAnnotationExpr n, Void arg) {
            }

            public void visit(MethodReferenceExpr n, Void arg) {
            }

            public void visit(NormalAnnotationExpr n, Void arg) {
                for (MemberValuePair m : Utils.emptyIfNull(n.getPairs())) {
                    m.accept((VoidVisitor)this, (Object)arg);
                }
            }

            public void visit(Parameter n, Void arg) {
            }

            public void visit(SingleMemberAnnotationExpr n, Void arg) {
                n.getMemberValue().accept((VoidVisitor)this, (Object)arg);
            }
        }, null);
    }

    private static class FieldAccessExprQualifier
    extends JavaFileAnalyzer.Qualifier<FieldAccessExpr> {
        public FieldAccessExprQualifier(FieldAccessExpr fieldAccessExpr) {
            super(fieldAccessExpr);
        }

        private FieldAccessExprQualifier(FieldAccessExpr fieldAccessExpr, FieldAccessExprQualifier parent) {
            super(fieldAccessExpr, parent);
        }

        @Override
        @Nullable
        protected JavaFileAnalyzer.Qualifier<?> getScopeQualifier(@Nonnull FieldAccessExpr reference) {
            Expression scope = reference.getScope();
            return NameExpr.class.isInstance(scope) ? new NameExprQualifier((NameExpr)NameExpr.class.cast(scope), this) : new FieldAccessExprQualifier((FieldAccessExpr)FieldAccessExpr.class.cast(scope), this);
        }

        @Override
        @Nonnull
        protected String getName(@Nonnull FieldAccessExpr reference) {
            return reference.getField();
        }

        @Override
        @Nonnull
        protected String getFullQualifier(@Nonnull FieldAccessExpr reference) {
            return ReferenceToConstantsAnalyzer.getFullQualifier(reference);
        }

        @Override
        public boolean allowsPartialResolving() {
            return true;
        }
    }

    private static class NameExprQualifier
    extends JavaFileAnalyzer.Qualifier<NameExpr> {
        public NameExprQualifier(NameExpr nameExpr) {
            super(nameExpr);
        }

        public NameExprQualifier(NameExpr nameExpr, FieldAccessExprQualifier parent) {
            super(nameExpr, parent);
        }

        @Override
        @Nullable
        protected JavaFileAnalyzer.Qualifier getScopeQualifier(@Nonnull NameExpr reference) {
            return null;
        }

        @Override
        @Nonnull
        protected String getName(@Nonnull NameExpr reference) {
            return reference.getName();
        }

        @Override
        @Nonnull
        protected String getFullQualifier(@Nonnull NameExpr reference) {
            return reference.getName();
        }

        @Override
        public boolean allowsPartialResolving() {
            return true;
        }

        @Override
        @Nonnull
        public Optional<String> examineInheritedType(@Nonnull CtClass referencingClazz, @Nonnull CtClass inheritedClazz) {
            for (CtField ctField : inheritedClazz.getDeclaredFields()) {
                if (!ctField.getName().equals(this.getName()) || !ctField.visibleFrom(referencingClazz)) continue;
                if (ReferenceToConstantsAnalyzer.isConstant(ctField)) {
                    return Optional.of((Object)inheritedClazz.getName());
                }
                return Optional.of((Object)referencingClazz.getName());
            }
            return Optional.absent();
        }
    }

    private static class LocalVariableRecordingVisitor<A>
    extends VoidVisitorAdapter<A> {
        @Nonnull
        private final Deque<Set<String>> localVariables = Lists.newLinkedList();

        private LocalVariableRecordingVisitor() {
        }

        private static Predicate<? super FieldDeclaration> constants() {
            return new Predicate<FieldDeclaration>(){

                public boolean apply(@Nullable FieldDeclaration fieldDeclaration) {
                    int modifiers = Utils.checkNotNull(fieldDeclaration).getModifiers();
                    return ModifierSet.isStatic((int)modifiers) && ModifierSet.isFinal((int)modifiers);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(ClassOrInterfaceDeclaration n, A arg) {
            HashSet fields = Sets.newHashSet();
            this.localVariables.addLast(fields);
            try {
                this.addFieldVariables((TypeDeclaration)n, (Set<String>)fields);
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(EnumDeclaration n, A arg) {
            HashSet fieldsAndEnums = Sets.newHashSet();
            this.localVariables.addLast(fieldsAndEnums);
            try {
                for (EnumConstantDeclaration enumConstantDeclaration : Utils.emptyIfNull(n.getEntries())) {
                    fieldsAndEnums.add(enumConstantDeclaration.getName());
                }
                this.addFieldVariables((TypeDeclaration)n, (Set<String>)fieldsAndEnums);
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(ObjectCreationExpr n, A arg) {
            HashSet fields = Sets.newHashSet();
            this.localVariables.addLast(fields);
            try {
                this.addFieldVariables(n.getAnonymousClassBody(), (Set<String>)fields);
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(ConstructorDeclaration n, A arg) {
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                for (Parameter parameter : Utils.emptyIfNull(n.getParameters())) {
                    blockVariables.add(parameter.getId().getName());
                }
                for (AnnotationExpr annotationExpr : Utils.emptyIfNull(n.getAnnotations())) {
                    annotationExpr.accept((VoidVisitor)this, arg);
                }
                BlockStmt body = n.getBlock();
                if (body != null) {
                    this.visit(body, arg);
                }
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(MethodDeclaration n, A arg) {
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                for (Parameter parameter : Utils.emptyIfNull(n.getParameters())) {
                    blockVariables.add(parameter.getId().getName());
                }
                for (AnnotationExpr annotationExpr : Utils.emptyIfNull(n.getAnnotations())) {
                    annotationExpr.accept((VoidVisitor)this, arg);
                }
                BlockStmt body = n.getBody();
                if (body != null) {
                    this.visit(body, arg);
                }
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(CatchClause n, A arg) {
            MultiTypeParameter multiTypeParameter = n.getExcept();
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                blockVariables.add(multiTypeParameter.getId().getName());
                for (AnnotationExpr annotationExpr : Utils.emptyIfNull(multiTypeParameter.getAnnotations())) {
                    annotationExpr.accept((VoidVisitor)this, arg);
                }
                BlockStmt body = n.getCatchBlock();
                if (body != null) {
                    this.visit(body, arg);
                }
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        public void visit(BlockStmt n, A arg) {
            this.localVariables.addLast(Sets.newHashSet());
            try {
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(ForeachStmt n, A arg) {
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                for (VariableDeclarator variableDeclarator : Utils.emptyIfNull(n.getVariable().getVars())) {
                    blockVariables.add(variableDeclarator.getId().getName());
                }
                n.getIterable().accept((VoidVisitor)this, arg);
                n.getBody().accept((VoidVisitor)this, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        public void visit(ForStmt n, A arg) {
            this.localVariables.addLast(Sets.newHashSet());
            try {
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(TryStmt n, A arg) {
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                for (VariableDeclarationExpr variableDeclarationExpr : Utils.emptyIfNull(n.getResources())) {
                    for (VariableDeclarator variableDeclarator : variableDeclarationExpr.getVars()) {
                        blockVariables.add(variableDeclarator.getId().getName());
                    }
                }
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(LambdaExpr n, A arg) {
            HashSet blockVariables = Sets.newHashSet();
            this.localVariables.addLast(blockVariables);
            try {
                for (Parameter parameter : Utils.emptyIfNull(n.getParameters())) {
                    blockVariables.add(parameter.getId().getName());
                }
                super.visit(n, arg);
            }
            finally {
                this.localVariables.removeLast();
            }
        }

        public void visit(VariableDeclarationExpr n, A arg) {
            for (AnnotationExpr annotationExpr : Utils.emptyIfNull(n.getAnnotations())) {
                annotationExpr.accept((VoidVisitor)this, arg);
            }
            n.getType().accept((VoidVisitor)this, arg);
            Set<String> blockVariables = this.localVariables.getLast();
            for (VariableDeclarator variableDeclarator : n.getVars()) {
                Expression expr = variableDeclarator.getInit();
                if (expr != null) {
                    expr.accept((VoidVisitor)this, arg);
                }
                blockVariables.add(variableDeclarator.getId().getName());
            }
        }

        protected final boolean aLocalVariableExists(@Nonnull String name) {
            return Iterables.contains((Iterable)Iterables.concat(this.localVariables), (Object)name);
        }

        private void addFieldVariables(@Nonnull TypeDeclaration typeDeclaration, @Nonnull Set<String> variables) {
            this.addFieldVariables(typeDeclaration.getMembers(), variables);
        }

        private void addFieldVariables(@Nullable Iterable<? extends BodyDeclaration> declarations, @Nonnull Set<String> variables) {
            for (FieldDeclaration fieldDeclaration : Utils.emptyIfNull(declarations).filter(FieldDeclaration.class).filter(Predicates.not(LocalVariableRecordingVisitor.constants()))) {
                for (VariableDeclarator variableDeclarator : fieldDeclaration.getVariables()) {
                    variables.add(variableDeclarator.getId().getName());
                }
            }
        }
    }
}

