/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Analyzer;
import de.is24.deadcode4j.IntermediateResult;
import de.is24.deadcode4j.Module;
import de.is24.deadcode4j.analyzer.AnalyzerAdapter;
import de.is24.deadcode4j.analyzer.InterfacesAnalyzer;
import de.is24.deadcode4j.analyzer.XmlAnalyzer;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ServletContainerInitializerAnalyzer
extends AnalyzerAdapter {
    private final String depender;
    private final Analyzer classFinder;
    private final Analyzer webXmlAnalyzer = new XmlAnalyzer("web.xml"){

        @Override
        @Nonnull
        protected DefaultHandler createHandlerFor(final @Nonnull AnalysisContext analysisContext) {
            return new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws XmlAnalyzer.StopParsing {
                    if ("web-app".equals(localName) && "true".equals(attributes.getValue("metadata-complete"))) {
                        ((ServletContainerInitializerAnalysisContext)analysisContext).setMetadataComplete();
                    }
                    throw new XmlAnalyzer.StopParsing();
                }
            };
        }
    };
    private ServletContainerInitializerAnalysisContext context;

    protected ServletContainerInitializerAnalyzer(String dependerId, String fqcnOfInitializerInterface) {
        this.depender = dependerId;
        this.classFinder = new InterfacesAnalyzer("ServletContainerInitializer-implementation", new String[]{fqcnOfInitializerInterface}){};
    }

    public ServletContainerInitializerAnalyzer() {
        this("JEE-ServletContainerInitializer", "javax.servlet.ServletContainerInitializer");
    }

    @Override
    public void doAnalysis(@Nonnull AnalysisContext analysisContext, @Nonnull File fileName) {
        if (this.context == null) {
            this.context = new ServletContainerInitializerAnalysisContext(analysisContext.getModule());
            this.context.setOriginalContext(analysisContext);
        }
        this.webXmlAnalyzer.doAnalysis(this.context, fileName);
        this.classFinder.doAnalysis(this.context, fileName);
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        ServletContainerInitializerAnalysisContext localContext = this.context;
        this.context = null;
        if (localContext == null) {
            return;
        }
        if (localContext.isMetadataComplete()) {
            this.logger.debug("Found web.xml with completed metadata; ServletContainerInitializer implementations are treated as dead code");
            return;
        }
        Iterable initializerClasses = Iterables.concat(localContext.getAnalyzedCode().getCodeDependencies().values());
        if (!Iterables.isEmpty((Iterable)initializerClasses)) {
            analysisContext.addDependencies(this.depender, initializerClasses);
        }
    }

    private static class ServletContainerInitializerAnalysisContext
    extends AnalysisContext {
        private AnalysisContext originalContext;
        private boolean metadataComplete = false;

        ServletContainerInitializerAnalysisContext(Module module) {
            super(module, Maps.newHashMap());
        }

        @Override
        @Nonnull
        public Map<Object, Object> getCache() {
            return this.originalContext.getCache();
        }

        @Override
        @Nullable
        public IntermediateResult getIntermediateResult(@Nonnull Object key) {
            return this.originalContext.getIntermediateResult(key);
        }

        @Override
        public void addAnalyzedClass(@Nonnull String clazz) {
            this.originalContext.addAnalyzedClass(clazz);
        }

        public void setMetadataComplete() {
            this.metadataComplete = true;
        }

        public boolean isMetadataComplete() {
            return this.metadataComplete;
        }

        public void setOriginalContext(AnalysisContext analysisContext) {
            this.originalContext = analysisContext;
        }
    }
}

