/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.XmlAnalyzer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SimpleXmlAnalyzer
extends XmlAnalyzer {
    protected final String dependerId;
    private final String rootElement;
    private final Set<Element> registeredElements = Sets.newHashSet();

    protected SimpleXmlAnalyzer(@Nonnull String dependerId, @Nonnull String endOfFileName, @Nullable String rootElement) {
        super(endOfFileName);
        this.dependerId = dependerId;
        this.rootElement = rootElement;
    }

    @Override
    public String toString() {
        String description = super.toString();
        if (this.rootElement == null) {
            return description;
        }
        return description + " with root Element <" + this.rootElement + ">";
    }

    @Override
    @Nonnull
    protected final DefaultHandler createHandlerFor(@Nonnull AnalysisContext analysisContext) {
        return new XmlHandler(analysisContext);
    }

    protected Element registerClassElement(@Nonnull String elementName) {
        Element element = new Element(elementName);
        element.reportTextAsClass();
        this.registeredElements.add(element);
        return element;
    }

    protected Element registerClassAttribute(@Nonnull String elementName, @Nonnull String attributeName) {
        Element element = new Element(elementName);
        element.setAttributeToReportAsClass(attributeName);
        this.registeredElements.add(element);
        return element;
    }

    private class XmlHandler
    extends DefaultHandler {
        private final AnalysisContext analysisContext;
        private boolean firstElement = true;
        private final Deque<Optional<StringBuilder>> textBuffers = new ArrayDeque<Optional<StringBuilder>>();

        public XmlHandler(AnalysisContext analysisContext) {
            this.analysisContext = analysisContext;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws XmlAnalyzer.StopParsing {
            if (this.firstElement && SimpleXmlAnalyzer.this.rootElement != null && !SimpleXmlAnalyzer.this.rootElement.equals(localName)) {
                throw new XmlAnalyzer.StopParsing();
            }
            this.firstElement = false;
            boolean recordText = false;
            for (Element registeredElement : SimpleXmlAnalyzer.this.registeredElements) {
                String className;
                String attributeToReportAsClass;
                if (!registeredElement.matches(localName, attributes)) continue;
                if (registeredElement.shouldReportTextAsClass()) {
                    recordText = true;
                }
                if ((attributeToReportAsClass = registeredElement.getAttributeToReportAsClass()) == null || (className = attributes.getValue(attributeToReportAsClass)) == null) continue;
                this.analysisContext.addDependencies(SimpleXmlAnalyzer.this.dependerId, className.trim());
            }
            this.textBuffers.addLast((Optional<StringBuilder>)(recordText ? Optional.of((Object)new StringBuilder()) : Optional.absent()));
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            Optional<StringBuilder> buffer = this.textBuffers.getLast();
            if (buffer.isPresent()) {
                ((StringBuilder)buffer.get()).append(new String(ch, start, length).trim());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            Optional<StringBuilder> optionalBuffer = this.textBuffers.removeLast();
            if (!optionalBuffer.isPresent()) {
                return;
            }
            StringBuilder buffer = (StringBuilder)optionalBuffer.get();
            if (buffer.length() > 0) {
                this.analysisContext.addDependencies(SimpleXmlAnalyzer.this.dependerId, buffer.toString());
            }
        }
    }

    protected static class Element {
        private final String name;
        private final Map<String, String> requiredAttributeValues = Maps.newHashMap();
        private boolean reportTextAsClass = false;
        private String attributeToReportAsClass;

        public Element(@Nonnull String name) {
            Preconditions.checkArgument((name.trim().length() > 0 ? 1 : 0) != 0, (Object)"The element's [name] must be set!");
            this.name = name;
        }

        public Element withAttributeValue(@Nonnull String attributeName, @Nonnull String requiredValue) {
            Preconditions.checkArgument((attributeName.trim().length() > 0 ? 1 : 0) != 0, (Object)"[attributeName] must be given!");
            Preconditions.checkArgument((requiredValue.trim().length() > 0 ? 1 : 0) != 0, (Object)"[requiredValue] must be given!");
            this.requiredAttributeValues.put(attributeName, requiredValue);
            return this;
        }

        void reportTextAsClass() {
            this.reportTextAsClass = true;
        }

        boolean shouldReportTextAsClass() {
            return this.reportTextAsClass;
        }

        String getAttributeToReportAsClass() {
            return this.attributeToReportAsClass;
        }

        void setAttributeToReportAsClass(@Nonnull String attributeName) {
            Preconditions.checkArgument((attributeName.trim().length() > 0 ? 1 : 0) != 0, (Object)"[attributeName] must be given!");
            Preconditions.checkState((this.attributeToReportAsClass == null ? 1 : 0) != 0, (Object)("Already registered [" + this.attributeToReportAsClass + "] as attribute to report as class!"));
            this.attributeToReportAsClass = attributeName;
        }

        boolean matches(String localName, Attributes attributes) {
            if (!this.name.equals(localName)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.requiredAttributeValues.entrySet()) {
                String currentValue;
                String expectedValue = entry.getValue();
                if (expectedValue.equals(currentValue = attributes.getValue(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
    }
}

