/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Lists;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.IntermediateResults;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import de.is24.javassist.CtClasses;
import java.util.List;
import java.util.Set;
import javassist.CtClass;
import javassist.Modifier;
import javax.annotation.Nonnull;

public class SpringDataCustomRepositoriesAnalyzer
extends ByteCodeAnalyzer {
    private final List<String> customRepositoryNames = Lists.newArrayList();

    @Override
    protected void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        analysisContext.addAnalyzedClass(clazz.getName());
        if (clazz.isInterface()) {
            this.analyzeInterface(analysisContext, clazz);
        } else if (this.isPublicOrPackageProtectedClass(clazz)) {
            this.reportImplementationOfExistingCustomRepository(analysisContext, clazz);
        }
    }

    @Override
    public void finishAnalysis(@Nonnull AnalysisContext analysisContext) {
        analysisContext.getCache().put(this.getClass(), IntermediateResults.resultSetFor(this.customRepositoryNames));
        this.customRepositoryNames.clear();
    }

    private void analyzeInterface(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        Set<String> implementedInterfaces = CtClasses.getAllImplementedInterfaces(clazz);
        if (!implementedInterfaces.contains("org.springframework.data.repository.Repository")) {
            return;
        }
        String nameOfCustomRepositoryInterface = clazz.getName() + "Custom";
        if (!implementedInterfaces.contains(nameOfCustomRepositoryInterface)) {
            return;
        }
        this.customRepositoryNames.add(nameOfCustomRepositoryInterface);
        this.reportImplementationOfNewCustomRepository(analysisContext, clazz);
    }

    private void reportImplementationOfNewCustomRepository(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        String clazzName = clazz.getName();
        String nameOfCustomRepositoryImplementation = clazzName + "Impl";
        CtClass customImpl = clazz.getClassPool().getOrNull(nameOfCustomRepositoryImplementation);
        if (customImpl == null) {
            return;
        }
        Set<String> implementedInterfaces = CtClasses.getAllImplementedInterfaces(customImpl);
        if (implementedInterfaces.contains(clazzName + "Custom")) {
            analysisContext.addDependencies(clazzName, nameOfCustomRepositoryImplementation);
        }
    }

    private boolean isPublicOrPackageProtectedClass(@Nonnull CtClass clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract((int)modifiers) && !Modifier.isAnnotation((int)modifiers) && !Modifier.isEnum((int)modifiers) && !Modifier.isPrivate((int)modifiers) && !Modifier.isProtected((int)modifiers);
    }

    private void reportImplementationOfExistingCustomRepository(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        IntermediateResults.IntermediateResultSet intermediateResults = IntermediateResults.resultSetFrom(analysisContext, this.getClass());
        if (intermediateResults == null) {
            return;
        }
        Set existingCustomRepositories = intermediateResults.getResults();
        Set<String> implementedInterfaces = CtClasses.getAllImplementedInterfaces(clazz);
        implementedInterfaces.retainAll(existingCustomRepositories);
        for (String customRepositoryName : implementedInterfaces) {
            analysisContext.addDependencies(customRepositoryName.substring(0, customRepositoryName.length() - "Custom".length()), clazz.getName());
        }
    }
}

