/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.collect.Iterables;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.AnalyzerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class SpringNamespaceHandlerAnalyzer
extends AnalyzerAdapter {
    @Override
    public void doAnalysis(@Nonnull AnalysisContext analysisContext, @Nonnull File file) {
        if (file.getAbsolutePath().endsWith("META-INF/spring.handlers")) {
            this.logger.debug("Analyzing property file [{}]...", (Object)file);
            this.registerSpringHandlersDefinedIn(analysisContext, file);
        }
    }

    private void registerSpringHandlersDefinedIn(AnalysisContext analysisContext, File file) {
        Properties springNamespaceHandlers = this.readPropertyFile(file);
        analysisContext.addDependencies("_Spring-NamespaceHandler_", Iterables.filter(springNamespaceHandlers.values(), String.class));
    }

    private Properties readPropertyFile(File file) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            properties.load(in);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to read [" + file + "]!", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }
}

