/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import de.is24.deadcode4j.analyzer.ExtendedXmlAnalyzer;
import javax.annotation.Nonnull;

public class SpringXmlAnalyzer
extends ExtendedXmlAnalyzer {
    private static void registerPropertyValueAsClass(@Nonnull ExtendedXmlAnalyzer.Path beanPath, @Nonnull String propertyName) {
        ExtendedXmlAnalyzer.Path propertyPath = beanPath.anyElementNamed("property").withAttributeValue("name", propertyName);
        propertyPath.registerAttributeAsClass("value");
        propertyPath.anyElementNamed("value").registerTextAsClass();
    }

    private static Optional<String> extractClassName(Optional<String> staticMethodCallNotation) {
        if (!staticMethodCallNotation.isPresent()) {
            return Optional.absent();
        }
        int lastDot = ((String)staticMethodCallNotation.get()).lastIndexOf(46);
        if (lastDot < 1) {
            return Optional.absent();
        }
        return Optional.of((Object)((String)staticMethodCallNotation.get()).substring(0, lastDot));
    }

    public SpringXmlAnalyzer() {
        super("_Spring-XML_", ".xml", "beans");
        this.anyElementNamed("bean").registerAttributeAsClass("class");
        ExtendedXmlAnalyzer.Path methodInvokingFactoryBean = this.beanOfClass("org.springframework.beans.factory.config.MethodInvokingFactoryBean");
        SpringXmlAnalyzer.registerPropertyValueAsClass(methodInvokingFactoryBean, "targetClass");
        ExtendedXmlAnalyzer.Path staticMethodProperty = methodInvokingFactoryBean.anyElementNamed("property").withAttributeValue("name", "staticMethod");
        staticMethodProperty.registerDependeeExtractor(new ExtendedXmlAnalyzer.DependeeExtractor(){

            @Override
            @Nonnull
            public Optional<String> extractDependee(@Nonnull Iterable<ExtendedXmlAnalyzer.XmlElement> xmlElements, @Nonnull Optional<String> containedText) {
                return SpringXmlAnalyzer.extractClassName((Optional<String>)((ExtendedXmlAnalyzer.XmlElement)Iterables.getLast(xmlElements)).getAttribute("value"));
            }
        });
        staticMethodProperty.anyElementNamed("value").registerDependeeExtractor(new ExtendedXmlAnalyzer.DependeeExtractor(){

            @Override
            @Nonnull
            public Optional<String> extractDependee(@Nonnull Iterable<ExtendedXmlAnalyzer.XmlElement> xmlElements, @Nonnull Optional<String> containedText) {
                return SpringXmlAnalyzer.extractClassName((Optional<String>)containedText);
            }
        });
        this.anyElementNamed("endpoint").registerAttributeAsClass("implementor");
        this.anyElementNamed("endpoint").anyElementNamed("implementor").registerTextAsClass();
        this.anyElementNamed("endpoint").registerAttributeAsClass("implementorClass");
        SpringXmlAnalyzer.registerPropertyValueAsClass(this.beanOfClass("org.springframework.scheduling.quartz.JobDetailBean"), "jobClass");
        SpringXmlAnalyzer.registerPropertyValueAsClass(this.beanOfClass("org.springframework.scheduling.quartz.JobDetailFactoryBean"), "jobClass");
        SpringXmlAnalyzer.registerPropertyValueAsClass(this.anyElementNamed("bean"), "viewClass");
    }

    @Nonnull
    private ExtendedXmlAnalyzer.Path beanOfClass(@Nonnull String beanClass) {
        return this.anyElementNamed("bean").withAttributeValue("class", beanClass);
    }
}

