/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.ByteCodeAnalyzer;
import de.is24.deadcode4j.analyzer.javassist.ClassPathFilter;
import de.is24.guava.NonNullFunction;
import de.is24.javassist.CtClasses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javassist.CtClass;
import javax.annotation.Nonnull;

public abstract class SuperClassAnalyzer
extends ByteCodeAnalyzer {
    private final String dependerId;
    private final NonNullFunction<AnalysisContext, Set<String>> supplySuperClassesFoundInClassPath;

    private SuperClassAnalyzer(@Nonnull String dependerId, @Nonnull Set<String> classNames) {
        Preconditions.checkArgument((!classNames.isEmpty() ? 1 : 0) != 0, (Object)"classNames cannot by empty!");
        this.dependerId = dependerId;
        this.supplySuperClassesFoundInClassPath = new ClassPathFilter(classNames);
    }

    protected SuperClassAnalyzer(@Nonnull String dependerId, String ... classNames) {
        this(dependerId, Sets.newHashSet((Object[])classNames));
    }

    public SuperClassAnalyzer(String dependerId, Iterable<String> classNames) {
        this(dependerId, Sets.newHashSet(classNames));
    }

    @Override
    protected final void analyzeClass(@Nonnull AnalysisContext analysisContext, @Nonnull CtClass clazz) {
        Set<String> knownSuperClasses = this.getSuperClassesFoundInClassPath(analysisContext);
        if (knownSuperClasses.isEmpty()) {
            return;
        }
        String clazzName = clazz.getName();
        analysisContext.addAnalyzedClass(clazzName);
        if (!Collections.disjoint(knownSuperClasses, this.getClassHierarchy(clazz))) {
            analysisContext.addDependencies(this.dependerId, clazzName);
        }
    }

    @Nonnull
    private List<String> getClassHierarchy(@Nonnull CtClass clazz) {
        ArrayList classes = Lists.newArrayList();
        CtClass loopClass = clazz;
        do {
            classes.add(loopClass.getClassFile2().getSuperclass());
        } while ((loopClass = CtClasses.getSuperclassOf(loopClass)) != null && !CtClasses.isJavaLangObject(loopClass));
        return classes;
    }

    @Nonnull
    protected final Set<String> getSuperClassesFoundInClassPath(@Nonnull AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(this.getClass(), this.supplySuperClassesFoundInClassPath);
    }
}

