/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Utils;
import de.is24.deadcode4j.analyzer.JavaFileAnalyzer;
import de.is24.javaparser.Nodes;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeErasureAnalyzer
extends JavaFileAnalyzer {
    @Nonnull
    private static String getFullQualifier(@Nonnull ClassOrInterfaceType classOrInterfaceType) {
        StringBuilder buffy = new StringBuilder(classOrInterfaceType.getName());
        while ((classOrInterfaceType = classOrInterfaceType.getScope()) != null) {
            buffy.insert(0, '.');
            buffy.insert(0, classOrInterfaceType.getName());
        }
        return buffy.toString();
    }

    @Override
    protected void analyzeCompilationUnit(final @Nonnull AnalysisContext analysisContext, @Nonnull CompilationUnit compilationUnit) {
        compilationUnit.accept((VoidVisitor)new TypeParameterRecordingVisitor<Void>(){
            private final Map<String, Set<String>> processedReferences = Maps.newHashMap();

            public void visit(ClassOrInterfaceType n, Void arg) {
                for (Type type : Utils.emptyIfNull(n.getTypeArgs())) {
                    ClassOrInterfaceType referencedType = this.getReferencedType(type);
                    if (referencedType == null || this.typeParameterWithSameNameIsDefined(referencedType)) continue;
                    this.resolveTypeReference(referencedType);
                    this.visit(referencedType, arg);
                }
            }

            @Nullable
            private ClassOrInterfaceType getReferencedType(@Nonnull Type type) {
                Type nestedType;
                if (ReferenceType.class.isInstance(type)) {
                    nestedType = ((ReferenceType)ReferenceType.class.cast(type)).getType();
                } else if (WildcardType.class.isInstance(type)) {
                    WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
                    ReferenceType referenceType = wildcardType.getExtends();
                    if (referenceType == null) {
                        referenceType = wildcardType.getSuper();
                    }
                    if (referenceType == null) {
                        return null;
                    }
                    nestedType = referenceType.getType();
                } else {
                    TypeErasureAnalyzer.this.logger.warn("Encountered unexpected Type [{}:{}]; please create an issue at https://github.com/ImmobilienScout24/deadcode4j.", type.getClass(), (Object)type);
                    return null;
                }
                if (PrimitiveType.class.isInstance(nestedType)) {
                    return null;
                }
                if (!ClassOrInterfaceType.class.isInstance(nestedType)) {
                    TypeErasureAnalyzer.this.logger.warn("[{}:{}] is no ClassOrInterfaceType; please create an issue at https://github.com/ImmobilienScout24/deadcode4j.", type.getClass(), (Object)type);
                    return null;
                }
                return (ClassOrInterfaceType)ClassOrInterfaceType.class.cast(nestedType);
            }

            private void resolveTypeReference(ClassOrInterfaceType referencedType) {
                if (!this.needsProcessing(referencedType)) {
                    return;
                }
                Optional<String> resolvedClass = JavaFileAnalyzer.resolveType(analysisContext, new ClassOrInterfaceTypeQualifier(referencedType));
                String depender = Nodes.getTypeName((Node)referencedType);
                if (resolvedClass.isPresent()) {
                    analysisContext.addDependencies(depender, (String)resolvedClass.get());
                } else {
                    TypeErasureAnalyzer.this.logger.debug("Could not resolve Type Argument [{}] used by [{}].", (Object)TypeErasureAnalyzer.getFullQualifier(referencedType), (Object)depender);
                }
            }

            private boolean needsProcessing(ClassOrInterfaceType referencedType) {
                Set<String> references = Utils.getOrAddMappedSet(this.processedReferences, Nodes.getTypeName((Node)referencedType));
                return references.add(TypeErasureAnalyzer.getFullQualifier(referencedType));
            }
        }, null);
    }

    private static class ClassOrInterfaceTypeQualifier
    extends JavaFileAnalyzer.Qualifier<ClassOrInterfaceType> {
        public ClassOrInterfaceTypeQualifier(ClassOrInterfaceType referencedType) {
            super(referencedType, null);
        }

        private ClassOrInterfaceTypeQualifier(ClassOrInterfaceType referencedType, ClassOrInterfaceTypeQualifier parent) {
            super(referencedType, parent);
        }

        @Override
        @Nonnull
        protected String getName(@Nonnull ClassOrInterfaceType referencedType) {
            return referencedType.getName();
        }

        @Override
        @Nonnull
        protected String getFullQualifier(@Nonnull ClassOrInterfaceType referencedType) {
            return TypeErasureAnalyzer.getFullQualifier(referencedType);
        }

        @Override
        @Nullable
        protected JavaFileAnalyzer.Qualifier getScopeQualifier(@Nonnull ClassOrInterfaceType referencedType) {
            ClassOrInterfaceType scope = referencedType.getScope();
            return scope == null ? null : new ClassOrInterfaceTypeQualifier(scope, this);
        }

        @Override
        public boolean allowsPartialResolving() {
            return false;
        }
    }

    private static class TypeParameterRecordingVisitor<A>
    extends VoidVisitorAdapter<A> {
        private final Deque<Set<String>> definedTypeParameters = Lists.newLinkedList();

        private TypeParameterRecordingVisitor() {
        }

        public void visit(ClassOrInterfaceDeclaration n, A arg) {
            this.definedTypeParameters.addLast(this.getTypeParameterNames(n.getTypeParameters()));
            try {
                super.visit(n, arg);
            }
            finally {
                this.definedTypeParameters.removeLast();
            }
        }

        public void visit(ConstructorDeclaration n, A arg) {
            this.definedTypeParameters.addLast(this.getTypeParameterNames(n.getTypeParameters()));
            try {
                super.visit(n, arg);
            }
            finally {
                this.definedTypeParameters.removeLast();
            }
        }

        public void visit(MethodDeclaration n, A arg) {
            this.definedTypeParameters.addLast(this.getTypeParameterNames(n.getTypeParameters()));
            try {
                super.visit(n, arg);
            }
            finally {
                this.definedTypeParameters.removeLast();
            }
        }

        public void visit(MethodReferenceExpr n, A arg) {
            this.definedTypeParameters.addLast(this.getTypeParameterNames(n.getTypeParameters()));
            try {
                super.visit(n, arg);
            }
            finally {
                this.definedTypeParameters.removeLast();
            }
        }

        protected boolean typeParameterWithSameNameIsDefined(@Nonnull ClassOrInterfaceType nestedClassOrInterface) {
            if (nestedClassOrInterface.getScope() != null) {
                return false;
            }
            for (Set<String> definedTypeNames : this.definedTypeParameters) {
                if (!definedTypeNames.contains(nestedClassOrInterface.getName())) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        private Set<String> getTypeParameterNames(@Nullable List<TypeParameter> typeParameters) {
            if (typeParameters == null) {
                return Collections.emptySet();
            }
            HashSet parameters = Sets.newHashSet();
            for (TypeParameter typeParameter : typeParameters) {
                parameters.add(typeParameter.getName());
            }
            return parameters;
        }
    }
}

