/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer;

import com.google.common.base.Preconditions;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.AnalyzerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlAnalyzer
extends AnalyzerAdapter {
    private final SAXParser parser;
    private final String endOfFileName;

    protected XmlAnalyzer(@Nonnull String endOfFileName) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set up XML parser!", e);
        }
        Preconditions.checkArgument((endOfFileName.trim().length() > 0 ? 1 : 0) != 0, (Object)"[endOfFileName] must be set!");
        this.endOfFileName = endOfFileName;
    }

    @Override
    public String toString() {
        return super.toString() + " analyzing [" + this.endOfFileName + "] files";
    }

    @Override
    public final void doAnalysis(@Nonnull AnalysisContext analysisContext, @Nonnull File file) {
        if (file.getName().endsWith(this.endOfFileName)) {
            this.logger.debug("Analyzing XML file [{}]...", (Object)file);
            this.analyzeXmlFile(analysisContext, file);
        }
    }

    @Nonnull
    protected abstract DefaultHandler createHandlerFor(@Nonnull AnalysisContext var1);

    /*
     * Loose catch block
     */
    private void analyzeXmlFile(@Nonnull AnalysisContext analysisContext, @Nonnull File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.parser.parse((InputStream)in, this.createHandlerFor(analysisContext));
        }
        catch (StopParsing stopParsing) {
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse [" + file + "]!", e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    protected static final class StopParsing
    extends SAXException {
        protected StopParsing() {
        }
    }
}

