/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer.javassist;

import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.javassist.ClassPoolAccessor;
import de.is24.guava.NonNullFunction;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathFilter
implements NonNullFunction<AnalysisContext, Set<String>> {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final Set<String> classes;

    public ClassPathFilter(@Nonnull Set<String> classes) {
        this.classes = classes;
    }

    @Override
    @Nonnull
    public Set<String> apply(@Nonnull AnalysisContext input) {
        ClassPool classPool = ClassPoolAccessor.classPoolAccessorFor(input).getClassPool();
        HashSet knownClasses = Sets.newHashSet();
        for (String className : this.classes) {
            if (classPool.find(className) == null) continue;
            knownClasses.add(className);
        }
        this.logger.debug("Found those classes in the class path: {}", (Object)knownClasses);
        return knownClasses;
    }
}

