/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer.javassist;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.Repository;
import de.is24.guava.NonNullFunction;
import de.is24.guava.SequentialLoadingCache;
import java.io.File;
import java.util.Set;
import javassist.ClassPool;
import javassist.NotFoundException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClassPoolAccessor {
    @Nonnull
    private static final NonNullFunction<AnalysisContext, ClassPoolAccessor> SUPPLIER = new NonNullFunction<AnalysisContext, ClassPoolAccessor>(){

        @Override
        @Nonnull
        public ClassPoolAccessor apply(@Nonnull AnalysisContext input) {
            return new ClassPoolAccessor(input);
        }
    };
    @Nonnull
    private final ClassPool classPool;
    @Nonnull
    private final LoadingCache<String, Optional<String>> classResolver;

    public ClassPoolAccessor(@Nonnull AnalysisContext analysisContext) {
        this.classPool = ClassPoolAccessor.createClassPool(analysisContext);
        this.classResolver = this.createResolverCache();
    }

    @Nonnull
    public static ClassPoolAccessor classPoolAccessorFor(@Nonnull AnalysisContext analysisContext) {
        return analysisContext.getOrCreateCacheEntry(ClassPoolAccessor.class, SUPPLIER);
    }

    @Nonnull
    private static ClassPool createClassPool(AnalysisContext analysisContext) {
        ClassPool classPool = new ClassPool(true);
        try {
            Repository outputRepository = analysisContext.getModule().getOutputRepository();
            if (outputRepository != null) {
                classPool.appendClassPath(outputRepository.getDirectory().getAbsolutePath());
            }
            for (File file : analysisContext.getModule().getClassPath()) {
                classPool.appendClassPath(file.getAbsolutePath());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Failed to set up ClassPool!", e);
        }
        return classPool;
    }

    private static String prepareQualifier(CharSequence qualifier) {
        String preparedQualifier = qualifier.toString();
        while (true) {
            int lastDot = preparedQualifier.lastIndexOf(46);
            int lastDollar = preparedQualifier.lastIndexOf(36);
            if (lastDollar < 0 || lastDot < 0 || lastDollar > lastDot) break;
            preparedQualifier = preparedQualifier.substring(0, lastDot) + "$" + preparedQualifier.substring(lastDot + 1);
        }
        return preparedQualifier;
    }

    @Nonnull
    public ClassPool getClassPool() {
        return this.classPool;
    }

    @Nonnull
    public Optional<String> resolveClass(@Nonnull CharSequence qualifier) {
        return (Optional)this.classResolver.getUnchecked((Object)ClassPoolAccessor.prepareQualifier(qualifier));
    }

    @Nonnull
    private LoadingCache<String, Optional<String>> createResolverCache() {
        return new SequentialLoadingCache<String, String>(new Function<String, Optional<String>>(){
            @Nonnull
            private final Set<String> knownPackages = Sets.newHashSet();

            @Nullable
            public Optional<String> apply(@Nullable String input) {
                if (input == null) {
                    return Optional.absent();
                }
                while (true) {
                    if (ClassPoolAccessor.this.classPool.getOrNull(input) != null) {
                        this.addToKnownPackages(input);
                        return Optional.of((Object)input);
                    }
                    int dotIndex = input.lastIndexOf(46);
                    if (dotIndex < 0) {
                        return Optional.absent();
                    }
                    String potentialPackage = input.substring(0, dotIndex);
                    if (this.knownPackages.contains(potentialPackage)) {
                        return Optional.absent();
                    }
                    input = potentialPackage + "$" + input.substring(dotIndex + 1);
                }
            }

            private void addToKnownPackages(@Nonnull String className) {
                int dotIndex;
                do {
                    if ((dotIndex = className.lastIndexOf(46)) >= 0) continue;
                    return;
                } while (this.knownPackages.add(className = className.substring(0, dotIndex)));
            }
        });
    }
}

