/*
 * Decompiled with CFR 0.152.
 */
package de.is24.deadcode4j.analyzer.webxml;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.is24.deadcode4j.AnalysisContext;
import de.is24.deadcode4j.analyzer.XmlAnalyzer;
import de.is24.deadcode4j.analyzer.webxml.Param;
import de.is24.deadcode4j.analyzer.webxml.WebXmlHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseWebXmlAnalyzer
extends XmlAnalyzer {
    protected BaseWebXmlAnalyzer() {
        super("web.xml");
    }

    @Nonnull
    protected abstract WebXmlHandler createWebXmlHandlerFor(@Nonnull AnalysisContext var1);

    @Override
    @Nonnull
    protected DefaultHandler createHandlerFor(@Nonnull AnalysisContext analysisContext) {
        WebXmlHandler webXmlHandler = this.createWebXmlHandlerFor(analysisContext);
        return new WebXmlAdapter(webXmlHandler);
    }

    private static class WebXmlAdapter
    extends DefaultHandler {
        static final Collection<List<String>> NODES_WITH_TEXT = Arrays.asList(Arrays.asList("web-app", "context-param", "param-name"), Arrays.asList("web-app", "context-param", "param-value"), Arrays.asList("web-app", "filter", "filter-class"), Arrays.asList("web-app", "filter", "init-param", "param-name"), Arrays.asList("web-app", "filter", "init-param", "param-value"), Arrays.asList("web-app", "listener", "listener-class"), Arrays.asList("web-app", "servlet", "servlet-class"), Arrays.asList("web-app", "servlet", "init-param", "param-name"), Arrays.asList("web-app", "servlet", "init-param", "param-value"));
        static final Collection<String> CONTEXT_PARAM_PATH = Arrays.asList("web-app", "context-param");
        static final Collection<String> FILTER_PATH = Arrays.asList("web-app", "filter");
        static final Collection<String> FILTER_INIT_PARAM_PATH = Arrays.asList("web-app", "filter", "init-param");
        static final Collection<String> LISTENER_PATH = Arrays.asList("web-app", "listener");
        static final Collection<String> SERVLET_INIT_PARAM_PATH = Arrays.asList("web-app", "servlet", "init-param");
        static final Collection<String> SERVLET_PATH = Arrays.asList("web-app", "servlet");
        final Deque<String> deque = new ArrayDeque<String>();
        final List<Param> initParams = new ArrayList<Param>();
        final Map<String, String> texts = new HashMap<String, String>();
        StringBuilder buffer;
        final WebXmlHandler webXmlHandler;

        WebXmlAdapter(WebXmlHandler webXmlHandler) {
            this.webXmlHandler = webXmlHandler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.deque.add(localName);
            if (this.isNodeWithText()) {
                this.buffer = new StringBuilder(128);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.isNodeWithText()) {
                this.buffer.append(new String(ch, start, length).trim());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.isNodeWithText()) {
                this.storeCharacters(localName);
            } else if (this.matchesPath(CONTEXT_PARAM_PATH)) {
                this.reportContextParam();
            } else if (this.matchesPath(FILTER_INIT_PARAM_PATH)) {
                this.storeInitParam();
            } else if (this.matchesPath(FILTER_PATH)) {
                this.reportFilter();
            } else if (this.matchesPath(LISTENER_PATH)) {
                this.reportListener();
            } else if (this.matchesPath(SERVLET_INIT_PARAM_PATH)) {
                this.storeInitParam();
            } else if (this.matchesPath(SERVLET_PATH)) {
                this.reportServlet();
            }
            this.deque.removeLast();
        }

        boolean isNodeWithText() {
            for (List<String> candidate : NODES_WITH_TEXT) {
                if (!this.matchesPath(candidate)) continue;
                return true;
            }
            return false;
        }

        void reportContextParam() {
            this.webXmlHandler.contextParam(this.createParam());
        }

        void storeInitParam() {
            this.initParams.add(this.createParam());
        }

        Param createParam() {
            return new Param(this.getText("param-name"), this.getText("param-value"));
        }

        void reportFilter() {
            this.webXmlHandler.filter(this.getText("filter-class"), new ArrayList<Param>(this.initParams));
            this.initParams.clear();
        }

        void reportListener() {
            this.webXmlHandler.listener(this.getText("listener-class"));
        }

        void reportServlet() {
            this.webXmlHandler.servlet(this.getText("servlet-class"), new ArrayList<Param>(this.initParams));
            this.initParams.clear();
        }

        boolean matchesPath(Collection<String> path) {
            return path.size() == this.deque.size() && Iterables.elementsEqual(path, this.deque);
        }

        void storeCharacters(String localName) {
            this.texts.put(localName, this.buffer.toString());
        }

        String getText(String localName) {
            String text = this.texts.remove(localName);
            return Strings.nullToEmpty((String)text);
        }
    }
}

